# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 172 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/putreq.al)"
;# send FTP request.
sub putreq ($$) {
	my $self = shift;
	my $req = shift;
	my $i = $self->{ftp_retry};

	$self->clearerror || return undef;

	$self->{lastcode} = 0;
	$self->{lastmesg} = '';

	do {
		# if we have no connection, try login.
		unless ($self->handle || $self->login) {
			$self->{lastmesg} = "can't login to the server";
			return undef;
		}

		# try send command.
		unless ($self->putln($req)) {
			$self->{lastmesg} = $self->error;
			return undef;
		}

		# check result, 421 means connection closed.
		unless ($self->getres == 421) {
			return $self->{lastcode}; # this is good!
		}

		# or 421 was returned.
		warn("FTP: server said code=421, try again.\n") if $LOG > 4;
		$self->quit;

	} while ($i-- > 0 && sleep(10)) ;

	warn("FTP: gave up \"$req\".\n") if $LOG > 4;
	$self->{lastmesg} = "putreq: too many retries";
	undef;
}

# end of Fan::FTP::putreq
1;
