# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 623 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/stat.al)"
;#
sub stat ($;$) {
	my $self = shift;
	my $command = "STAT";
	$command .= ' '.shift if @_;

	if ($self->putreq($command) !~ /^2/) {
		$self->error($self->{lastmesg});
		return undef;
	}

	local $_ = $self->{buffer};
	s/\r//g;			# ignore "\r".
	1 while s/^\d\d\d-[^\n]*\n//;	# skip prepended messages
	s/^total\s+\d+\n//;		# ignore first "total ..."
	s/(^|\n)2\d\d ([^\n]*$)//;	# skip result message

	# Some FTP servers or FTP gateways close connection by STAT
	# command. Check it now!
	my $tmp = $2;
	if ($tmp =~ /good\s?bye/i) {
		if ($LOG > 4) {
			warn("stat: server said \"$self->{lastmesg}\"\n");
			warn("stat: connection might be closed.\n");
			warn("stat: check your server.\n");
		}
		$self->error("stat: connection might be closed");
		return undef;
	}

	# or concatinated string will be returned.
	$_;
}

# end of Fan::FTP::stat
1;
