# NOTE: Derived from ../blib/lib/Fan/FTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::FTP;

#line 80 "../blib/lib/Fan/FTP.pm (autosplit into ../blib/lib/auto/Fan/FTP/stats.al)"
;# Show statistics report.
sub stats ($) {
	my $self = shift;
	my $name = $self->{ftp_server};
	my $p;

	exists($stats{$name}) && ref($p = $stats{$name}) or return undef;

	my $cs = $p->{ctrl_sent} + 0;
	my $cr = $p->{ctrl_recv} + 0;
	my $ds = $p->{data_sent} + 0;
	my $dr = $p->{data_recv} + 0;

	1 while $cs =~ s/(\d+)(\d\d\d)/$1,$2/;
	1 while $cr =~ s/(\d+)(\d\d\d)/$1,$2/;
	1 while $ds =~ s/(\d+)(\d\d\d)/$1,$2/;
	1 while $dr =~ s/(\d+)(\d\d\d)/$1,$2/;

	my $len = 0;
	$len = length($cs) if $len < length($cs);
	$len = length($cr) if $len < length($cr);
	$len = length($ds) if $len < length($ds);
	$len = length($dr) if $len < length($dr);

	warn("$self status reports (server name: $name)\n");
	warn(" sent(ctrl)". '.' x ($len + 3 - length($cs)) . " $cs octets\n");
	warn(" recv(ctrl)". '.' x ($len + 3 - length($cr)) . " $cr octets\n");
	warn(" sent(data)". '.' x ($len + 3 - length($ds)) . " $ds octets\n");
	warn(" recv(data)". '.' x ($len + 3 - length($dr)) . " $dr octets\n");

	1;
}

# end of Fan::FTP::stats
1;
