# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 129 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/d_begin.al)"
;#
;# farm_begin ...
;# initialize farm index updater.
;#
sub d_begin ($) {
	my $p = shift;
	my $dir = $p->{work_directory};
	my $fh;

	# clear
	$p->{pim_stack} = [];
	$p->{pim_depth} = 0;
	$p->{pim_modified} = 0;

	# Check revisions...
	exists($p->{pim_index_new}) || $p->getrev or return undef;

	# check revision numbers
	my $rev = $p->{pim_index_new};
	$p->{pim_index} = "$dir/index.$rev";
	$p->{pim_index_tmp} = $p->{pim_index}.'.tmp';

	local *TMPINDEX;
	unless (open(TMPINDEX, ">$p->{pim_index_tmp}")) {
		carp("d_begin open($p->{pim_index_tmp}): $!");
		return undef;
	}
	$p->{pim_index_handle} = *TMPINDEX;

	# information log...
	warn("Farm::begin: open $p->{pim_index_tmp}: o.k.\n") if $LOG > 5;

	# CAUTION:
	# WE CAN GENERATE STEP FILE EVEN IF WE ARE CREATING A NEW
	# INDEX FILE, BUT WE SHOULD GENERATE STEP FILE FROM INDEX
	# FILES...
	return 1;

	# shall we go step mode?
	$rev > 1 || return 1;

	# we are required step mode.
	$rev--;
	$p->{pim_step} = "$dir/step.$rev";
	$p->{pim_step_tmp} = $p->{pim_step}.'.tmp';

	#
	local *TMPSTEP;
	unless (open(TMPSTEP, ">$p->{pim_step_tmp}")) {
		carp("Farm::begin: open($p->{pim_step_tmp}): $!");
		return undef;
	}
	$p->{pim_step_handle} = *TMPSTEP;

	# information log...
	warn("Farm::begin: open $p->{pim_step_tmp}: o.k.\n") if $LOG > 5;

	# success
	1;
}

# end of Fan::Farm::d_begin
1;
