# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 402 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/generate.al)"
;# Master mode:
;# Generate full index of the given directory.
;# (as the newest index).
;#
;# this routine should be called after `update' routine.
;#
;# Usage:
;#	$p->generate(directory);
;#	where `directory' is the target directory.
;#
sub generate ($$) {
	my $p = shift;
	my $dir = $p->{work_directory};
	my $target = shift;

	# Check revisions...
	exists($p->{pim_index_new}) || $p->getrev or return undef;

	# Get revision...
	my $rev = $p->{pim_index_new};
	my $outp = "$dir/index.$rev";
	my $temp = "$outp.tmp";

	# open temorary output file.
	unless (&Fan::Scan::scan_mklist($temp, $target)) {
		carp("generate:Fan:: Scan::mklist failure");
		return undef;
	}

	# try compare...
	$rev--;
	if (exists($p->{pim_index_max}) && $p->{pim_index_max} == $rev) {
		my $old = "$dir/index.$rev";
		my $step = "$dir/step.$rev";
		my $tmps = "$step.tmp";

		my $mod = &Fan::Scan::scan_mkdiff($tmps, $old, $temp);
		if (!defined($mod)) {
			warn("generate: scan_mkdiff failure, skipped.\n");
		} elsif ($mod == 0) {
			unlink($tmps);
			warn("generate: no change, $tmps removed.\n")
				if $LOG > 5;
			unlink($temp);
			warn("generate: no change, $temp removed.\n")
				if $LOG > 5;
			return 1; # this is success case.
		} else {
			if (rename($tmps, $step)) {
				warn("generate: rename $tmps -> $step: o.k.\n")
					if $LOG > 5;
			} else {
				carp("generate: rename $tmps -> $step: $!");
				unlink($tmps);
			}
		}
	}

	# now, try to rename.
	unless (rename($temp, $outp)) {
		carp("generate: rename $temp -> $outp: $!");
		unlink($temp);
		return undef;
	}

	#
	warn("generate: rename $temp -> $outp: o.k.\n") if $LOG > 5;

	# success
	1;
}

# end of Fan::Farm::generate
1;
