# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 471 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/normalize.al)"
;# Master and slave mode:
;# Normalize index directory.
;# (a) generate all step files.
;# (b) index files are removed except the newest one.
;#     (but, show warning messages only, in this version.)
;# (c) all step files remain.
;#
sub normalize ($;$) {
	my $p = shift;
	my $clean = shift;
	my $dir = $p->{work_directory};

	# Force to check revisions...
	$p->getrev or return undef;

	# Check existence of index files...
	if (!exists($p->{pim_index_max})) { # we have no index file.
		carp("normalize: have no index file") if $LOG > 4;
		return undef;
	}

	# Update index files and calculate revisions again, if needed.
	if (exists($p->{pim_step_max})) {
		if ($p->{pim_step_max} >= $p->{pim_index_max}) {
			$p->update && $p->getrev or return undef;
		}
	}

	# Next, check step files.
	my $max_i = $p->{pim_index_max}; # DOES exist
	my $rev = $p->{pim_index_min}; # DOES exist
	$rev = $p->{pim_step_max} + 1 if exists($p->{pim_step_max});

	# loop.
	while ($rev < $max_i) {
		my $out = "$dir/step.$rev";
		my $tmp = "$out.tmp";
		my $old = "$dir/index.$rev";
		$rev++;
		my $new = "$dir/index.$rev";

		unless (defined(&Fan::Scan::scan_mkdiff($tmp, $old, $new))) {
			carp("normalize: can't make diff");
			unlink($tmp);
			return undef;
		}
		unless (rename($tmp, $out)) {
			carp("normalize: rename $tmp -> $out: $!");
			unlink($tmp);
			return undef;
		}
		warn("normalize: rename $tmp -> $out: o.k.\n") if $LOG > 5;
	}

	# unlink redundant files...
	for ($rev = $p->{pim_index_min}; $rev < $max_i; $rev++) {
		if ($clean) {
			unlink("$dir/index.$rev");
			warn("normalize: unlink $dir/index.$rev\n") if $LOG > 5;
		} else {
			warn("normalize: we should unlink $dir/index.$rev\n")
				if $LOG > 5;
		}
	}

	# get revision numbers once more.
	unless ($p->getrev) {
		carp("normalize: can't update revision numbers");
		return undef;
	}

	# shall we clean up?
	$clean || return 1;

	# abbrev for revision numbers.
	my $min_s = 0;
	my $min_i = 0;

	# Initialize...
	$min_s = $p->{pim_step_min} if exists($p->{pim_step_min});
	$min_i = $p->{pim_index_min} if exists($p->{pim_index_min});

	# Open working directory
	local *DIR;
	unless (opendir(DIR, $dir)) {
		carp("normalize: opendir($dir): $!") if $LOG > 4;
		return undef;
	}

	# Search invalid step/index files
	my $e;
	while (defined($e = readdir(DIR))) {
		if ($e =~ /^step\.(\d+)(\.Z|\.gz)?$/) {
			if (!$min_s || $1 < $min_s) {
				warn("normalize: unlink $dir/$e\n")
					if $LOG > 5;
				# unlink("$dir/$e");
			}
		} elsif ($e =~ /^index\.(\d+)(\.Z|\.gz)?$/) {
			if (!$min_i || $1 < $min_i) {
				warn("normalize: unlink $dir/$e\n")
					if $LOG > 5;
				# unlink("$dir/$e");
			}
		} else {
			; # simply ignored...
		}
	}
	closedir(DIR);

	# success code.
	1;
}

# end of Fan::Farm::normalize
1;
