# NOTE: Derived from ../blib/lib/Fan/Farm.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Farm;

#line 584 "../blib/lib/Fan/Farm.pm (autosplit into ../blib/lib/auto/Fan/Farm/update.al)"
;# Master and slave mode:
;# Generate the newest index file from step files.
;#
;# Usage:
;#	$p->updage;
;#
sub update ($) {
	my $p = shift;
	my $dir = $p->{work_directory};

	# Check revisions...
	exists($p->{pim_index_new}) || $p->getrev or return undef;

	# Check existence of index files...
	if (!exists($p->{pim_index_max})) { # we have no index file.
		carp("update: can't find base index file.\n") if $LOG > 4;
		return undef;
	}

	# Next, check step files.
	if (!exists($p->{pim_step_max})) { # no step file.
		warn("update: no step file.\n") if $LOG > 5;
		return 1; # seems good.
	}

	# Check revision numbers.
	if ($p->{pim_step_max} < $p->{pim_index_max}) {
		warn("update: revision check o.k.\n") if $LOG > 5;
		return 1; # seems good.
	}

	# Now, we can generate the newest index file.
	my $min = $p->{pim_index_max}; # we have...
	my $max = $p->{pim_step_max}; # we have...
	my $new = $max + 1;

	# Open the index who has maximum number.
	my $orig = "$dir/index.$min";
	my @diff = ();
	while ($min <= $max) {
		push(@diff, "$dir/step.$max");
		$min++;
	}

	my $outp = "$dir/index.$new";
	my $temp = "$outp.tmp";

	# update by Fan::Scan::scan_update.
	unless (&Fan::Scan::scan_update($temp, $orig, @diff)) {
		warn("update: Fan::Scan::scan_update failure\n");
		unlink($temp); # unlink temporary file
		return undef;
	}

	# now try to rename...
	unless (rename($temp, $outp)) {
		carp("update: rename($outp): $!") if $LOG > 4;
		unlink($temp); # unlink temporary file
		return undef;
	}

	# debug log
	warn("update: rename $temp -> $outp: o.k.\n") if $LOG > 5;

	# success
	1;
}

# end of Fan::Farm::update
1;
