# NOTE: Derived from ../blib/lib/Fan/HTTP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::HTTP;

#line 88 "../blib/lib/Fan/HTTP.pm (autosplit into ../blib/lib/auto/Fan/HTTP/get.al)"
;# connecting the server, and get contents.
sub get ($$;$) {
	my $self = shift;
	my ($proto, $server, $port, $document) = &parse_url(shift);
	my $out = shift;
	my $tmp;
	my $need_rename = 0;
	my $fh;
	local *OUTPUT;

	if ($document !~ /^\//) {
		carp("$self: document must begin with a slash"),
		return undef;
	}

	if ($out eq '') {
		$fh = \*STDOUT;
	} elsif (ref($out) eq 'GLOB') {
		$fh = $out;
	} else {
		($tmp = $out) =~ s%[^/]+$%.in.$&%;
		$need_rename++;

		CORE::open(OUTPUT, ">$tmp") or
			carp("$self: open($tmp) - $!"), return undef;
		$fh = \*OUTPUT;
	}

	$proto = $self->{http_proto} if $proto eq '';
	$proto = 'http' if $proto eq '';

	$server = $self->{http_server} if $server eq '';
	if ($server eq '') {
		carp("$self: host not specified"), return undef;
	}

	if ($self->{http_proxy} eq '') {
		if ($proto ne 'http') {
			carp("$self: protocol $proto is not supported");
			return undef;
		}
		$port = 80 if $port eq '';
	} else {
		if (defined($port)) { # normal port
			$document = sprintf("%s://%s:%d%s",
				$proto, $server, $port, $document);
		} else {
			$document = sprintf("%s://%s%s",
				$proto, $server, $document);
		}
		$server = $self->{http_proxy};
		$port = $server =~ s/:(\d+)$// ? $1 : 80;
	}

# carp("$self: ($proto, $server, $port, $document)") if $LOG > 6;

warn("HTTP: try to connect $server:$port\n") if $LOG > 6;
warn("HTTP: try to get $document\n") if $LOG > 6;

	unless ($self->do_client(tcp_host => $server, tcp_port => $port)) {
		# error string was stored by do_client.
		$self->close;
		return undef;
	}

	$self->putln("GET $document HTTP/1.0")		&&
	$self->putln("Accept: */*")			&&
	$self->putln("User-Agent: HTTP.pm/$VERSION")	&&
	$self->putln("")				or
	$self->close, return undef;

	defined($_ = $self->getln)			&&
	/^HTTP\/\d+\.\d+ (\d\d\d) (.+)$/		or
	$self->error("wrong response"), $self->close, return undef;

	my $result = $1;
	my $reason = $2;
	my @headers = ();

warn("HTTP: result=$result reason=$2\n") if $LOG > 6;

	my $null = 0;
	while (defined($_ = $self->getln)) {
		$null++, last if /^$/;
		$_ = pop(@headers).$_ if /^\s/;
		push(@headers, $_);
	}

	unless ($null) {
		$self->error("unexpected end of file");
		$self->close;
		return undef;
	}

	# parsing headers
	while (@headers) {
		$_ = shift(@headers);

		unless (s/^([a-zA-Z\-]+):\s+//) {
			$self->error("wrong header");
			$self->clsoe;
			return undef;
		}
		my $tag = "\L$1";
                if ($tag eq 'content-type') {
			if (/\s*([-\w]+)\/([-\w]+)\s*(;\s*([^\s;]+)\s*)*$/) {
				$self->{content_type} = $1;
				$self->{content_subtype} = $2;
			}
                } elsif ($tag eq 'content-length') {
			$self->{content_length} = $_;
                } elsif ($tag eq 'content-encoding') {
			$self->{content_encoding} = $_;
		} elsif ($tag eq 'content-transfer-encoding') {
			$self->{content_transfer_encoding} = $_;
		} elsif ($tag eq 'last-modified') {
			$self->{last_modified} = $_;
                } else {
			# simply ignored
		}
	}

	# get total length of this contents
	my $length = defined($self->{content_length}) ?
		$self->{content_length} + 0 : undef;

	# try to read real data.
	my $len = 0;
	my $ll = defined($length) && $length < 10240 ? $length : 10240;
	while ($ll > 0 && defined(my $data = $self->getdata($ll))) {
		unless (print $fh $data) {
			$self->error($!.'');
			$self->close;
			return undef;
		}
		$len += length($data);
		$ll = defined($length) && $length - $len < 10240
			? $length - $len : 10240;
	}

	# o.k., now close this session.
	$self->close;
	if ($self->error) {
		return undef;
	}

	# checking result...
	unless ($result == 200) {
		$self->error("\"$reason\"");
		return undef;
	}

	# check length...
	if (defined($length) && $length != $len) {
		$self->error('length mismatch');
		return undef;
	}

	# rename if we wrote to a plain file
	if ($need_rename) {
		unless (rename($tmp, $out)) {
			my $e = $!."";
			$self->error("rename($out): $e");
			return undef;
		}
	}

	# success
	1;
}

# end of Fan::HTTP::get
1;
