# NOTE: Derived from ../blib/lib/Fan/Param.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Param;

#line 355 "../blib/lib/Fan/Param.pm (autosplit into ../blib/lib/auto/Fan/Param/combine.al)"
;# Combine some parameters for Param objects.
;# $p->combine($a, $b, ..., $z, $flag) will combine as follows:
;# in order of $a, $b, ..., $z, copy parameter values to $p.
;# If $flag is non zero, override is permitted.
;#
sub combine ($@) {
	my $p = shift; # output object
	my @list = ();
	my $count = 0;
	my $n;

	# check Param objects.
	while (defined($n = shift) && ref($n) && $n->isa('Fan::Param')) {
		push(@list, $n);
	}

	# now $n is the flag of override.
	my $param;
	for $param (@list) {
		my $key;
		my $val;
		while (($key, $val) = each %{$param}) {
			next if $key =~ /^param_/;
			if (exists($p->{$key})) {
				if ($val =~ /^\n/) { # append
					$val = $p->{$key}.$val;
				} elsif (!$n) { # not override
					next;
				}
			}
			if ($p->try_check($key)) {
				$p->{$key} = $val; # copy
				$count++;
			} else {
				; # simply ignored
			}
		}
	}

	# succeeded
	1;
}

# end of Fan::Param::combine
1;
