# NOTE: Derived from ../blib/lib/Fan/Param.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Param;

#line 172 "../blib/lib/Fan/Param.pm (autosplit into ../blib/lib/auto/Fan/Param/new.al)"
;# Create a new Param object.
;#
sub new ($%) {
	my $this = shift;
	my $class = ref($this) || $this;
	my %param = @_;
	my $self = { param_error => 0 };

	# Count up param objects.
	$param_sequence++;

	# Pick up some special parameters.
	$self->{param_name} = $param{param_name} || "Param[$param_sequence]";

	# Check keys param object.
	if (ref($param{param_keys}) eq 'HASH') {
		$self->{param_keys} = $param{param_keys}; # save ref
	}

	# Check keys for nesting parameters.
	if (ref($param{param_nest}) eq 'HASH') {
		$self->{param_nest} = $param{param_nest}; # save ref
	}

	# Create a new object.
	bless $self, $class or return undef;

	# Log message for debugging purpose
	carp("Param CREATING $self [$self->{param_name}]") if $LOG > 5;

	# Register (key, val) pairs in %param.
	my $key;
	my $val;
	while (($key, $val) = each %param) {
		$self->setval($key, $val) if $key !~ /^param_/;
	}

	# Return myself.
	$self;
}

# end of Fan::Param::new
1;
