# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 737 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/dir_ftp.al)"
;#
;# Usage:
;#	array_ref = $scan->dir_ftp(directory);
;#
sub dir_ftp ($$) {
	my $self = shift;
	my $dir = shift;
	my $d = "$self->{scan_dir}/$dir";
	my $ftp = $self->{scan_ftp};
	my $hash = undef;

	# try to get magic array for this directory
	if ($self->{scan_dirinfo}) {
		use Fan::DIR;

		my $tmp = "/tmp/dirinfo.$$";
		my $info = Fan::DIR->new();
		if ($ftp->get("$d/.dirinfo", $tmp) && $info->load($tmp)) {
			my $f;
			for $f ($info->index) {
				$hash->{$f} = $info->get($f);
			}
		} elsif ($ftp->fatal) {
			carp("Scan: can't get dirinfo, fatal") if $LOG > 5;
			return undef;
		} else {
			carp("Scan: can't get dirinfo, try nest") if $LOG > 5;
		}
		unlink($tmp);
	}

	# no scan_dirinfo, or fail to load dirinfo.
	if (!defined($hash)) {
		local $_ = $ftp->list($d);

		unless (defined($_)) {
			warn("Scan: can't get list of $d\n") if $LOG > 5;
			return undef;
		}

		$hash = {};
		my $x;
		for $x (split(/\n/)) {
			my $y;
			if (!defined($y = Fan::Attrib->new(attr_list => $x))) {
				warn("$x: could not parse, ignored.\n")
					if $LOG > 6;
			} else {
				$hash->{$y->name} = $y;
			}
		}
	}

	my $x;
	my $p = [];
	for $x (sort keys %{$hash}) {
		if ($x ne '' && $x ne '.' && $x ne '..') {
			$hash->{$x}->realpath("$d/$x");
			push(@{$p}, $hash->{$x});
		}
	}
	$self->{magic_array}->{$dir} = $p;
}

# end of Fan::Scan::dir_ftp
1;
