# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 704 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/dir_local.al)"
;#
;# Usage:
;#	array_ref = $scan->dir_local(directory);
;#
sub dir_local ($$) {
	my $self = shift;
	my $dir = shift;
	my $d = "$self->{scan_dir}/$dir";
	my $p = [];

	local(*D);
	opendir(D, $d) or carp("opendir($d): $!"), return undef;
	my @entry = readdir(D);
	closedir(D);

	# for all entries
	my $e;
	for $e (sort @entry) {
		next if $e eq '' || $e eq '.' || $e eq '..';
		my $x = Fan::Attrib->new(
			attr_path => "$d/$e",
			attr_no_checksum => $self->{scan_no_checksum}
		);
		if (defined($x)) {
			# $x->realpath("$d/$e");
			push(@{$p}, $x);
		}
	}

	# return a reference to array.
	$self->{magic_array}->{$dir} = $p;
}

# end of Fan::Scan::dir_local
1;
