# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 998 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/fileglob.al)"
;# convert file name to a file glob.
;#
sub fileglob ($;$) {
	my $file = shift;
	my $m = @_ ? shift : ''; # mode...

	# do nothing if $file is a file glob.
	return $file if ref($file) eq 'GLOB';

	# check modes.
	$m = '<' if $m eq 'r';
	$m = '>' if $m eq 'w';
	$m = '>>' if $m eq 'a';

	# check modes...
	unless ($m eq '' || $m eq '<' || $m eq '>' || $m eq '>>') {
		carp("fileglob: wrong mode to open operation") if $LOG >= 5;
		return undef;
	}

	# check special filename.
	if ($file eq '' || $file eq '-') { 
		if ($m eq '' || $m eq '<') {
			return \*STDIN;
		} else {
			return \*STDOUT;
		}
	}

	# try to open the target file.
	local *TEMP;
	unless (CORE::open(TEMP, $m.$file)) {
		carp("fileglob: open($m.$file): $!") if $LOG >= 5;
		return undef;
	}

	# debug log...
	warn("fileglob: open[".fileno(*TEMP)."] $file: o.k.\n") if $LOG > 5;

	# result
	*TEMP;
}

# end of Fan::Scan::fileglob
1;
