# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 385 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/get.al)"
;#
;#
sub get ($) {
	my $self = shift;
	my $y;

	# If there is an entry in hold buffer, we return it.
	delete($self->{hold}), return $y if defined($y = $self->{hold});

	# Get one!
	# When a directory object was marked as 'IGNORED' by filter,
	# we should ignore any additional files in that directory.
	my $ignore_nest = 0;
	while (defined($y = $self->getone)) {

		warn($y->to_line."\n") if $LOG >= 8; # in full debug mode

		# Check if we are in an ignored directory.
		if ($ignore_nest > 0) {
			$ignore_nest-- if $y->type eq 'U';
			$y->flag('!'); # and skip this entry.
		}

		# Shall we return this attrib object?
		if ($y->flag eq '!') {
			$self->{ignore_nest}++ if $y->type eq 'D';
		} else {
			last; # 
		}
	}

	# Check error.
	if (!defined($y)) {
		if ($self->{founderror}) {
			# This may be dangerous, so we should terminate
			# any processing.
			croak("Scan::get: error was detected");
		}
	}

	# The result
	$y;
}

# end of Fan::Scan::get
1;
