# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 550 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/get_index.al)"
;#
sub get_index ($) {
	my $self = shift;
	my $fh = $self->{handle};

	# Check end-of-file or error.
	return undef if $self->{endofdata} || $self->{founderror};

	# DEBUG mode only.
	confess("\$fh must be defined") unless defined($fh);

	# Try to read from the file handle.
	local $_;
	while (defined($_ = <$fh>)) {
		# skip trailing spaces, and ignore comment lines.
		s/\s+$//;
		/^$/ || /^#/ || last;
warn("READ($.): $_\n");
	}

	# Check end-of-file.
	if (!defined($_)) {
		carp("file [".fileno($fh)."] unexpected END-OF-FILE at $.");
		$self->{founderror}++;
		return undef;
	}

	# Let's parse it.
	my $y = Fan::Attrib->new(attr_line => $_);

	# Check result.
	ref($y) && $y->isa('Fan::Attrib')
		or carp("Can't create Attrib from $_"), return undef;

	# where am I?
	my $d;
	if (!defined($d = $self->where)) {
		$y->path('.');
		$self->start;
	} else {
		if ($y->type eq '.') {
			$self->end;
		} elsif ($y->type eq 'U') {
			$y->path($d);
			$self->up;
		} else {
			$y->path($d.'/'.$y->name);
			if ($y->type eq 'D') {
				$self->down($y->name);
			}
		}
	}

	# try filter
	$y->flag('!') unless $self->perform_filter($y);

	# result is Attrib or undef.
	$y;
}

# end of Fan::Scan::get_index
1;
