# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 921 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/getcmp.al)"
;#
;# Get an array of ``smallest'' attributes from
;# a list of Scan objects.
;#
sub getcmp ($@) {
	my @array = @_;
	my $end = 0;
	my $z = undef; # the smallest attribute
	my $pp;

	# Search smallest entry, first
	for $pp (@array) {
		my $p;
		if (defined($p = $pp->get)) {
			$pp->unget($p);
			$z = $p if !defined($z) || $p->compare($z) < 0;
		} else {
			$end++;
		}
	}

	# Check end-of-data
	if ($end == @array) {
		return wantarray ? () : undef;
	} elsif ($end > 0) {
		confess("Some unexpected case occured");
	}

	# OK, $z is the smallest one, try to generate result.
	my @result = ();

	# Get an item if smallest values can be found.
	for $pp (@array) {
		my $p = $pp->get;
		if ($z->compare($p)) {
			$pp->unget($p);
			push(@result, undef);
		} else {
			push(@result, $p);
		}
	}

	# Result is an list of attributes.
	@result;
}

# end of Fan::Scan::getcmp
1;
