# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 818 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/getline_lslR.al)"
;#
;# read a line from ls-lR format file, and parse it.
;# if full entries for a directory $d was found,
;# you can access directory info for that directory from
;# $self->{magic_array}->{$d}.
;#
sub getline_lslR ($){
	my $self = shift;
	my $fh = $self->{handle};
	local $_;

	# check previouse error or end-of-file
	return undef if $self->{endoffile} || $self->{founderror};

	# validate file handle
	confess("Can't find file handle") unless defined($fh);

	# y structure, separator
	my $delim = 0;

	# read a line
	if (!(defined($_ = <$fh>))) {
		$self->{endoffile}++, $delim++;
	} elsif (/^$/) { # null line
		$delim++; # end-of-directory
	} elsif (/^total (\d+)/) { # maybe start of a directory.
		# we simply ignore this.
	} elsif (/^.[-r][-w][-xsS][-r][-w][-xsS][-r][-w][-xtT]\s*/) {
		# normal entry - check this format before directory pattern
		# tested in next statement, because we hate a filename which
		# ends with ':'.
		my $y;
		if (!defined($y = Fan::Attrib->new(attr_list => $_))) {
			warn("$_: could not parse, ignored\n") if $LOG >= 7;
		} else {
			my $n = $y->name;
			if ($n ne '' && $n ne '.' && $n ne '..') {
				$self->{cur_info}->{$n} = $y; # registered.
			}
		}
	} elsif (/:$/) { # new directory
		my $d = $`;
		if (!defined($self->{subst})) {
			my $s = quotemeta($d =~ m%[^/]+$% ? $` : '');
			$self->{subst} = sub {
				local($_) = @_; s|^$s|./|; $_; };
		}
		$self->{lslR_curdir} = &{$self->{subst}}($d);
	} else { # other case?
		warn("$_ unknown format, ignored\n") if $LOG >= 7;
		$self->{founderror}++;
		return undef;
	}

	# directory delimiter
	if ($delim) {
		my $d = $self->{lslR_curdir};
		delete($self->{lslR_curdir});
		my $p = $self->{cur_info};
		$self->{cur_info} = {};
		my $q = $self->{magic_array}->{$d} = [];
### DEBUG BEGIN (for debug only)
		if ($d ne '.' && $d !~ /^\.\//) {
			confess("directory name must begin with '.'\n");
		}
### DEBUG END
		my $n;
		for $n (sort keys %{$p}) {
			push(@{$q}, $p->{$n});
		}
	}

	# success return
	1;
}

# end of Fan::Scan::getline_lslR
1;
