# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 430 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/getone.al)"
;#
;# Get a single entry from index tree.
;#
sub getone ($) {
	my $self = shift;
	my $y;

	# Check end-of-file or error.
	return undef if $self->{endofdata} || $self->{founderror};

	# Check array reference. Error in next statement is critical.
	if (ref($self->{dirs}) ne 'ARRAY') {
		confess("\$self->{dirs} must be ARRAY");
	}

	# Try to parse and store to $y.
	$y = $self->{scan_index} ? $self->get_index : $self->get_misc;

	# Check result.
	unless (ref($y) && $y->isa('Fan::Attrib')) {
		carp("getone: can't get Fan::Attrib object");
		$self->{founderror}++;
		return undef;
	}

	# We prefer an abbrev for the type of this Attrib object.
	my $t = $y->type;

	# If last one is a directory, go down there.
	if (exists($self->{nextdir})) {
		push(@{$self->{dirs}}, $self->{nextdir});
		delete($self->{nextdir}); # clean next directory entry
	}

	# We assume the first entry is the `.' directory.
	if (@{$self->{dirs}} == 0) { # this is the first time
		if (!($t eq 'D' && $y->name eq '.')) {
			carp("First entry must be the \".\" directory.");
			$self->{founderror}++;
			return undef;
		}
		$self->{nextdir} = '.'; # save to hold buffer
		return $y;
	}

	# Type '.' means END-OF-DATA.
	if ($t eq '.') {
		if (@{$self->{dirs}} == 1) { # verify o.k.
			pop(@{$self->{dirs}});
			$self->{endofdata}++;
			return $y;
		}
		if (@{$self->{dirs}} > 1) {
			carp("remaining directories: \""
				.join('/', @{$self->{dirs}})."\"");
		} else {
			carp("No directory in stack");
		}
		$self->{founderror}++;
		return undef;
	}

	# Type 'U' is `Go to the up stair'.
	if ($t eq 'U') { # one dir up
		if (@{$self->{dirs}} < 2) {
			carp("Too many dir UP");
			$self->{founderror}++;
			return undef;
		}
		$y->name(pop(@{$self->{dirs}})); # not return yet
	}

	# Remaining cases require `name' attribute. Check it.
	my $n = $y->name;
	if (!defined($n)) {
		confess("$y: no name found.");
	} elsif ($n =~ m%[\001\377]%) {
		confess("$y: name contains illegal charactor.");
	} elsif ($n =~ m%/([^/]+)$%) { # contains slash(es)
		confess("$y: name contains slash(es).");
	} elsif ($n eq '.' || $n eq '..') {
		confess("$y: \"$n\" is invalid.");
	} else {
		; # o.k.
	}

	# DEBUG mode only.
	# Calculate pathname from directory array.
	my $path = join('/', @{$self->{dirs}}, $n);
	confess($y->path." != $path") unless $y->path eq $path;

	# Type 'U' was already processed.
	if ($t eq 'U') {
		return $y;
	}

	# Type 'D' is a directory. Copy to the nextdir hold buffer.
	if ($t eq 'D') {
		$self->{nextdir} = $n;
		return $y;
	}

	# Type 'L' is a symlink.
	if ($t eq 'L') { # symlink
		if (!defined($y->linkto)) { # linkto is required
			carp("$y: no linkto for symlink");
			$self->{founderror}++;
			return undef;
		}
		return $y;
	}

	# Type 'F' is a normal file.
	if ($t eq 'F') { # normal file
		return $y;
	}

	# Or, unknown type is specified.
	carp("$t: illegal type");
	return undef;
}

# end of Fan::Scan::getone
1;
