# NOTE: Derived from ../blib/lib/Fan/Scan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::Scan;

#line 1103 "../blib/lib/Fan/Scan.pm (autosplit into ../blib/lib/auto/Fan/Scan/scan_mkdiff.al)"
;#
;# Generate diffs for given two index files.
;# scan_mkdiff(output, old, new)
;#
;# Return codes:
;#	undef	error was detected.
;#	0	diff file was generated, but no change exists.
;#	other	# of changes. diff file was generated.
;#
sub scan_mkdiff ($$$) {
	my $file = shift;
	my $old = shift;
	my $new = shift;

	my $op = &fileglob($file, 'w');
	my $no = fileno($op);

	if (!defined($no)) {
		carp("scan_mkdiff: fileglog($file): failure.") if $LOG > 5;
		return undef;
	}

	# debug log
	if (ref($op) eq 'GLOB') { # normal file.
		warn("scan_mkdiff: use[$no] $file: o.k.\n") if $LOG > 5;
	} else {
		warn("scan_mkdiff: open[$no] $file: o.k.\n") if $LOG > 5;
	}

	my $oldscan = Fan::Scan->guess($old);

	unless(ref($oldscan) && $oldscan->isa('Fan::Scan')) {
		carp("scan_mkdiff: can't create scanner($old)");
		return undef;
	}

	my $newscan = Fan::Scan->guess($new);

	unless(ref($newscan) && $newscan->isa('Fan::Scan')) {
		carp("scan_mkdiff: can't create scanner($new)");
		return undef;
	}

	my @dir = ();	# directry stack
	my $modify = 0;	# modification flag
	my $a;
	my $b;
	while (($a, $b) = $oldscan->getcmp($newscan)) {

		# check difference first.
		if (!defined($a) && !defined($b)) {
			confess("scan_mkdiff: UNEXPECTED CASE");
		} elsif (!defined($a)) {
			$b->flag('+');
		} elsif (!defined($b)) {
			$b = $a; $b->flag('-');
		} elsif (attr_cmp($a, $b)) { # differs
			$b->flag('+');
		} else {
			$b->flag('');
		}

		# print difference if required.
		if ($b->type eq '.') {
			print $op ".\n"; # END-OF-DATA.
		} elsif ($b->type eq 'D' && $b->name eq '.') {
			print $op $b->to_line."\n";
		} elsif ($b->flag ne '') {
			while (@dir) {
				print $op shift(@dir)->to_line."\n";
			}
			print $op $b->to_line."\n";
			$modify++;
		} elsif ($b->type eq 'D') {
			push(@dir, $b);
		} elsif ($b->type eq 'U') {
			if (@dir) {
				pop(@dir);
			} else {
				print $op "U\n";
			}
		} else { # (flag == '' && type !~ /[DU.]/)
			; # ignored
		}
	}

	# close if needed.
	if (ref($op) eq 'GLOB') {
		warn("scan_mkdiff: unuse[$no] $file...\n") if $LOG > 5;
	} else {
		warn("scan_mkdiff: close[$no] $file...\n") if $LOG > 5;
	}

	# this causes the target file be closed automatically.
	undef $op;

	# return # of differences.
	$modify;
}

# end of Fan::Scan::scan_mkdiff
1;
