# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 510 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/do_client.al)"
;# connecting the server.
sub do_client ($%) {
	my $self = shift;
	my %params = @_;
	my $sock;

	# close handle if exists
	$self->close;

	# clear error or return
	$self->clearerror(1);

	# parse argument
	my $port = $params{tcp_port} || $self->{tcp_port};
	my $host = $params{tcp_host} || $self->{tcp_host};

	# check required parameters
	if ($port eq '') {
		$self->error("no tcp_port", &FATAL);
		carp("$self: tcp_port not defined");
		return undef;
	}
	if ($host eq '') {
		$self->error("no tcp_host", &FATAL);
		carp("$self: tcp_host not defined");
		return undef;
	}

	# check server name and try to parse port number
	my @infos = getaddrinfo($host, $port, AF_UNSPEC, SOCK_STREAM);
	if ($#infos < 1) {
		carp("$self: getaddrinfo($host, $port) - $?");
		my $e = $?.'';
		$self->error($e, &FATAL);
		carp("$self: getaddrinfo($host, $port) - $e");
		return undef;
	}

	# Perl's bug? once connect fails, we could not any more
	# connect (connect returns "Invalid Argument"). So we
	# create/close a socket in each iteration.
	while ($#infos >= 1) {
		my ($family, $socktype, $proto, $peer, $canonname)
		    = splice(@infos, 0, 5);

		# open socket stores any error
		$params{tcp_family} = $family;
		$self->open_socket(%params) || return undef;

		my $result = undef;

		# do real work.
		eval {
			local $SIG{'ALRM'} = sub { die("alarm\n") };
			alarm($self->{tcp_timeout});
			$result = connect($self->{tcp_sock}, $peer);
			alarm(0);
		};

		# check result.
		if ($result) {
			$self->nowait; # let this socket non-blocking
warn("$self connect ok, local="
	.$self->sockname.", remote=".$self->peername."\n")
	if $LOG > 5 || $self->{tcp_debug};
			return 1; # success
		}
		if ($@) {
			if ($@ ne "alarm\n") {
				croak($@); # other evaluation error
			}
			warn("do_client: TIME OUT\n") if $LOG > 5;
			$self->error("operation timed out"); # not fatal.
		} else {
			# this is not a critical error, yet.
			my $e = $!.'';
			$self->error($e);
			carp("$self: connect - $e") if $LOG >= 6;
		}

		# perhaps, this is a perl's bug...
		$self->close; # or error found.
	}

	# or all connect were failed.
	# carp("all connect sessions were failed");
	$self->error($self->error, &FATAL);
	undef;
}

# end of Fan::TCP::do_client
1;
