# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 602 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/do_server.al)"
;#
;# open accept socket, and listen at specified addr/port.
;#
sub do_server ($%) {
	my $self = shift;
	my %param = @_;

	# close handle if exists
	$self->close;

	# clear error first
	$self->clearerror(1);

	# default backlog is 5.
	my $backlog = $param{tcp_backlog} > 0 ? $param{tcp_backlog} : 5;

	# opening new socket.
	$self->open_socket(%param) || return undef;

	# try real work
	unless (listen($self->{tcp_sock}, $backlog)) {
		my $e = $!.'';
		$self->error($e, &FATAL);
		carp("$self: listen - $e");
		return undef;
	}

	# success to listen
	1;
}

# end of Fan::TCP::do_server
1;
