# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 391 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/getdata.al)"
;# recv data to server
sub getdata ($$) {
	my $self = shift;
	my $length = shift;
	my $sock = $self->handle;
	my $data = '';
	my $len = 0;
	my $ok = undef;

	# DEBUG only - check socket!
	defined($sock) or confess("TCP: socket is not defined");

	# try to clear current status.
	$self->clearerror || return undef;

	# get a line from socket
	eval {
		local $SIG{'ALRM'} = sub { die("alarm\n") };
		alarm($self->{tcp_timeout});
		$len = read($sock, $data, $length);
		alarm(0);
	};

	# check result.
	if ($@) {
		if ($@ eq "alarm\n") {
			warn("getdata: TIME OUT\n") if $LOG > 5;
			$self->error("operation timed out", &FATAL);
			return undef;
		}
		croak($@); # other evaluation error
	}

	# check result
	unless (defined($len) && $len > 0) {
		$self->{endoffile}++, return undef;
	}

	# or success to recv data
	if ($LOG > 6 || $self->{tcp_debug}) {
		my $fno = fileno($self->{tcp_sock});
		warn("$self [$fno] read $len octets.\n");
	}

	# count up sent data size
	$self->{tcp_recv_octets} += $len;

	# success, and return this line.
	$data;
}

# end of Fan::TCP::getdata
1;
