# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 279 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/getln.al)"
;# recieve one line respone from server.
sub getln ($) {
	my $self = shift;
	my $sock = $self->handle;
	my $line = undef;

	# DEBUG only - check socket!
	defined($sock) or confess("TCP: socket is not defined");

	# try to clear current status.
	$self->clearerror || return undef;

	# if we already found end-of-file, return undef
	return undef if $self->{endoffile};

	# get a line from socket
	eval {
		local $SIG{'ALRM'} = sub { die("alarm\n") };
		alarm($self->{tcp_timeout});
		$line = <$sock>;
		alarm(0);
	};

	# check result.
	if ($@) {
		if ($@ eq "alarm\n") {
			warn("getln: TIME OUT\n") if $LOG > 5;
			$self->error("operation timed out", &FATAL);
			return undef;
		}
		carp($@); # other evaluation error
	}

	# check result
	unless (defined($line)) { # this is not an error
		warn("TCP getln: END-OF-FILE detected.\n") if $LOG > 6;
		$self->{endoffile}++, return undef;
	}

	# or success to read a line
	chomp($line);
	$line =~ s/\r?$//;

	# debug log
	if ($LOG > 6 || $self->{tcp_debug}) {
		my $fno = fileno($self->{tcp_sock});
		warn("$self [$fno] getln: $line\n");
	}

	# count up sent data size
	$self->{tcp_recv_octets} += length($line) + 2;

	# success, and return this line.
	$line;
}

# end of Fan::TCP::getln
1;
