# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 708 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/handle.al)"
;#
sub handle ($) {
	my $self = shift;

	# check existence of tcp_sock - we must have this.
	unless (exists($self->{tcp_sock})) {
		carp("$self has no tcp_sock") if $LOG > 6;
		return undef;
	}

	# copy to a local variable.
	my $s = $self->{tcp_sock};

	# validate our socket.
	unless (defined($s) && defined(fileno($s))) {
		carp("$self->tcp_sock is not a file handle") if $LOG > 7;
		return undef;
	}

	# DEBUG information.
	if ($LOG > 7) {
		my $fno = fileno($s);
		warn("$self->tcp_sock=[$fno]\n");
	}

	# return file handle itself.
	$s;
}

# end of Fan::TCP::handle
1;
