# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 634 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/new_client.al)"
;#
;# Accept a new connection at listening socket,
;# and create a new TCP object.
;#
sub new_client ($) {
	my $self = shift;
	my $sock;

	defined($sock = $self->handle) || return undef;

	my $client = $self->new; # client = new TCP object.
	my $result = 0;

	local *SOCKET;

	eval {
		local $SIG{'ALRM'} = sub { die("alarm\n") };
		alarm($self->{tcp_timeout});
		$result = accept(SOCKET, $sock);
		alarm(0);
	};

	# check result.
	if ($@) {
		if ($@ eq "alarm\n") {
			warn("new_client: TIME OUT\n") if $LOG > 5;
			$self->error("operation timed out", &FATAL);
			return undef;
		}
		croak($@); # other evaluation error
	}

	# result of accept
	unless ($result) {
		my $e = $!.'';
		$self->error($e, &FATAL);
		carp("accept: $e");
		return undef;
	}

	# store...
	$client->{tcp_sock} = *SOCKET;

	# debug log...
	if ($LOG > 5 || $self->{tcp_debug}) {
		my $fno = fileno($client->{tcp_sock});
		warn("$self [$fno] was accepted.\n");
	}

	# set no wait
	$client->nowait;
	$client;
}

# end of Fan::TCP::new_client
1;
