# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 455 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/open_socket.al)"
;# opening socket...
;# and if bindport / bindaddr was specified, we try to 
;# bind the socket.
;# this should be a internal routine.
sub open_socket ($%) {
	my $self = shift;
	my %params = @_;

	# try clear error first.
	$self->clearerror || return undef;

	# if we already have a socket, close it first.
	$self->close;

	# check local side port #.
	my $port = $params{tcp_bindport} || $self->{tcp_bindport} || 0;

	# define local side address if bindaddr is not null string.
	my $family = $params{tcp_family} ? $params{tcp_family} : AF_INET;
	my $tcp_bindaddr = $params{tcp_bindaddr} || $self->{tcp_bindaddr} ||
			   (($family == AF_INET) ? '0.0.0.0' : '::');

	my ($socktype, $proto, $me, $canonname);
	($family, $socktype, $proto, $me, $canonname)
		= getaddrinfo($tcp_bindaddr, $port, $family, SOCK_STREAM);

	# local file handle...
	local *SOCKET;

	# creating a stream socket.
	unless (socket(SOCKET, $family, $socktype, $proto)) {
		my $e = $!.'';
		$self->error($e, &FATAL);
		carp("$self: socket - $e") if $LOG >= 5;
		return undef;
	}

	# bind addresses.
	unless (bind(SOCKET, $me)) {
		my $e = $!.'';
		$self->close;
		$self->error($e, &FATAL);
		carp("$self: bind - $e") if $LOG >= 5;
		return undef;
	}

	# debug log...
	if ($LOG > 5 || $self->{tcp_debug}) {
		warn("$self [".fileno(SOCKET)."] was opened.\n");
	}

	# save it
	$self->{tcp_sock} = *SOCKET;

	# success to create and bind socket.
	*SOCKET;
}

# end of Fan::TCP::open_socket
1;
