# NOTE: Derived from ../blib/lib/Fan/TCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan::TCP;

#line 223 "../blib/lib/Fan/TCP.pm (autosplit into ../blib/lib/auto/Fan/TCP/putln.al)"
;# Send a line with CR/LF.
sub putln ($$) {
	my $self = shift;
	my $sock = $self->handle;
	my $line = shift;
	my $ok = 0;

	# DEBUG only - check socket!
	defined($sock) or confess("TCP: socket is not defined");

	# try to clear current status.
	$self->clearerror || return undef;

	# remove trailing spaces. DO NOT in this version.
	# $line =~ s/\s+$//;

	# print a line with CR/LF.
	eval {
		local $SIG{'ALRM'} = sub { die("alarm\n") };
		alarm($self->{tcp_timeout});
		$ok = print $sock ($line."\r\n");
		alarm(0);
	};

	# check result.
	if ($@) {
		if ($@ eq "alarm\n") {
			warn("putln: TIME OUT\n") if $LOG > 5;
			$self->error("operation timed out", &FATAL);
			return undef;
		}
		croak($@); # other evaluation error
	}

	# check result.
	unless ($ok) {
		my $e = $!.'';
		return $self->error($e, &FATAL);
		warn("TCP putln($line): $e\n") if $LOG > 6;
		carp("$self: print - $e");
		return undef;
	}

	# debug log
	if ($LOG > 6 || $self->{tcp_debug}) {
		my $fno = fileno($self->{tcp_sock});
		warn("$self [$fno] putln: $line\n");
	}

	# count up sent data size
	$self->{tcp_sent_octets} += length($line) + 2;

	# success to put lines.
	1;
}

# end of Fan::TCP::putln
1;
