# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1750 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/besame.al)"
;#
;# $p->besame($a, $b, $op)
;#	where $a and $b are Attrib objects,
;#
;# $op is the operation code and flags.
;#
;# case of ($op & 7) == 0:
;#	Function `besame' simply checks whether $a is same as $b.
;#	If $a is equevalent to $b then 0(zero) will be returned,
;#	otherwise undef will be returned.
;# case of ($op & 7) == 1:
;#	Same as the case of $op == 0, but modification times are
;#	good if the condition (mtime_of_$a >= mtime_of_$b) holds.
;# case of ($op & 7) == 2:
;#	Function `besame' checks and try to modify $a to be same
;#	as $b. If $a could be same as $b, the # of modifications
;#	will be returned (this may be zero or positive integer.).
;#	If $a has no possibility to become $b, undef is returned.
;#	In this case, `$a->realpath' must exists.
;#	In a modified time check, if ($op & 0x80) is not zero,
;#	modified time must be same, e.g., undef is returned when
;#	modified time mismatch found.
;# case of ($op & 7) == 3:
;#	Same as the case of $op == 2, but no real modification
;#	will be performed. This is useful for test mode.
;#
;# and if ($op & 8) is true, `besame' requires mtimes for $a and
;# $b must match.
;#
sub besame ($$$;$) {
	my $p = shift; # myself
	my $a = shift; # Attrib object
	my $b = shift; # Attrib object
	my $modify = 0;
	my $op;
	my $path = undef;
	my $key;
	my $val;
	my $ftp = $p->{via_ftp};

	# DEBUG purpose only.
	confess("$a must be an Attrib")
		unless ref($a) && $a->isa('Fan::Attrib');
	confess("$b must be an Attrib")
		unless ref($b) && $b->isa('Fan::Attrib');

	# Set operation type.
	if (@_) {
		$op = shift;
	} else { # or default operation type.
		$op = $p->put_mode ? 1 :
			$p->test_mode ? 3 : 2; 
	}

	# Must we check mtime?
	my $check_mtime = $op & 8;
	$op &= 7;

	plog(8, "* besame($a, $b, $op)\n");

	# $op == 2 may modify real path attributes.
	if ($op == 2) {
		my $t = $a->{y_realpath};
		$path = $t if $t ne '' && -e $t; # check existence
	}

	# for logging
	my $x = $a->path;

	# Types must match.
	$key = 'y_type';
	$val = exists($b->{$key}) ? $b->{$key} : undef;
	if ($a->{$key} ne $val) {
		plog(7, "$x: type differs.\n");
		return undef;
	}

	# Check symlink
	if ($val eq 'L') {
		$key = 'y_linkto';
		$val = exists($b->{$key}) ? $b->{$key} : undef;
		if ($a->{$key} eq $val) {
			plog(8, "$x: symlink check ok.\n");
		} elsif ($op == 2 && $path) { # modification is permitted
			unlink($path); # type == symlink was checked.
			symlink($val, $path);
			$a->{$key} = $val;
			$modify++;
			plog(8, "$x: symlink modify ok.\n");
		} elsif ($op == 3) {
			$a->{$key} = $val;
			$modify++;
			plog(8, "$x: symlink will be changed.\n");
		} else {
			plog(7, "$x: symlink mismatch.\n");
			return undef;
		}
		## return $modify; # no more check is required for symlink. 

	} elsif ($val eq 'F') { # Check a regular file.

		# Size must match, too.
		$key = 'y_size';
		$val = exists($b->{$key}) ? $b->{$key} : undef;
		if (!exists($a->{$key}) || !defined($val)) {
			plog(8, "$x: skip size test.\n");
		} elsif ($a->{$key} == $val) {
			plog(8, "$x: size check ok.\n");
		} else {
			plog(7, "$x: size differs.\n");
			return undef; # this is a critical error
		}

		# MD5 checksum must match if exists.
		$key = 'y_checksum';
		$val = exists($b->{$key}) ? $b->{$key} : undef;
		if (!exists($a->{$key}) || !defined($val)) {
			plog(8, "$x: skip checksum test.\n");
		} elsif ($a->{$key} eq $val) {
			plog(8, "$x: checksum test ok.\n");
			# In this case, MD5CHECKSUM is same, so
			# We need not check mtime.
			$check_mtime = 0;
		} else {
			plog(7, "$x: checksum differs.\n");
			return undef; # this is a critical error
		}

		# By default we require mtime check.
		my $need_mtime_check = 0;
		my $ta;
		my $tb;
		my $tt;
		my $z;

		# Undefined modified time means that the attribute was
		# filled with FTP LIST information (including ls-lR).
		# So, at least one of $a or $b must have modified time.
		$key = 'y_mtime';
		if (exists($a->{$key}) && exists($b->{$key})) {
			$need_mtime_check++;
		} elsif (exists($a->{$key})) {
			if (!defined($p->ftp_offset) &&
				$b->{y_date} =~ /\d\d?:\d\d/ &&
				$p->fill_mtime($b)) {
				$need_mtime_check++;
			} else {
				$tt = $ta = $a->{$key} + $p->ftp_offset;
				$tb = $b->{y_time0};
				$z = $b;
			}
		} elsif (exists($b->{$key})) {
			if (!defined($p->ftp_offset) &&
				$a->{y_date} =~ /\d\d?:\d\d/ &&
				$p->fill_mtime($a)) {
				$need_mtime_check++;
			} else {
				$ta = $a->{y_time0};
				$tt = $tb = $b->{$key} + $p->ftp_offset;
				$z = $a;
			}
		} else { # THIS MUST NOT OCCUR
			confess("neither of $a or $b has no mtime");
			die; die; die;
		}

		# check time0 / date before mtime check.
		if ($need_mtime_check) {
			; # skip this
		} elsif ($ta == $tb) {
			plog(8, "$x: time0 check ok.\n");
		} elsif ($op == 1 && $ta > $tb) {
			plog(8, "$x: time0 seems good.\n");
		} elsif (date_check($z->date, $tt)) {
			plog(8, "$x: time0(date) check ok.\n");
		} elsif ($p->fill_mtime($z)) {
			$need_mtime_check++; # get mtime o.k., warp to next.
		} elsif ($check_mtime) {
			plog(8, "$x: time0 check failed.\n"), return undef;
		} elsif ($op == 2) {
			if ($p->put_mode) { # this is FTP server's file
				plog(7, "$x: time0 do nothing, ignored.\n");
			} elsif ($path && ! -l $path) {
				unless (utime($tb, $tb, $path)) {
					warn("utime($path): $!");
					return undef;
				}
				$a->{y_time0} = $tb;
				$modify++;
				plog(8, "$x: time0 modify ok.\n");
			} else {
				plog(7, "$x: time0 no file found.\n");
				### return undef;
			}
		} elsif ($op == 3) {
			$a->{y_time0} = $val;
			$modify++;
			plog(8, "$x: mtime will be changed.\n");
		} else {
			plog(8, "$x: time0 check error.\n"), return undef;
		}

		#
		$key = 'y_mtime';
		$val = $b->{$key};
		if (!$need_mtime_check) {
			; # simply skip this check
		} elsif (!exists($a->{$key}) || !defined($val)) {
			plog(8, "$x: skip mtime check.\n"); # really?
		} elsif ($a->{$key} == $val) {
			plog(8, "$x: mtime check ok.\n");
		} elsif ($op == 1 && $a->{$key} > $val) {
			plog(8, "$x: mtime seems good.\n");
		} elsif ($check_mtime) {
			plog(8, "$x: mtime check failed.\n"), return undef;
		} elsif ($op == 2) {
			if ($p->put_mode) { # this is FTP server's file
				plog(7, "$x: mtime do nothing, ignored.\n");
			} elsif ($path && ! -l $path) {
				unless (utime($val, $val, $path)) {
					warn("utime($path): $!");
					return undef;
				}
				$a->{$key} = $val;
				$modify++;
				plog(8, "$x: mtime modify ok.\n");
			} else {
				plog(7, "$x: mtime no file found, ignored.\n");
				### return undef;
			}
		} elsif ($op == 3) {
			$a->{$key} = $val;
			$modify++;
			plog(8, "$x: mtime will be changed.\n");
		} else {
			plog(8, "$x: mtime check error.\n"), return undef;
		}
	}

	# Addtional checks are only for $op == 2 || $op == 3.
	return 0 unless $op == 2 || $op == 3;

	# Check permission.
	$key = 'y_perm';
	$val = $b->{$key};
	if (!exists($a->{$key}) || !defined($val)) {
		plog(8, "$x: skip perm test.\n");
	} elsif ($a->{$key} == $val) {
		plog(8, "$x: perm check ok.\n");
	} elsif ($op == 2) {
		if ($p->put_mode) { # this is FTP server's file
			my $ftp = $p->{via_ftp}; # MUST EXIST
			warn("try chmod $path\n") if $LOG >= 5;
			if ($ftp->chmod($val, $path)) {
				$modify++;
				plog(8, "$x: perm modify ok.\n");
			} else {
				warn("FTP::chmod($path): [".$ftp->error."]\n")
					if $LOG >= 6;
				# but ignore this error
				plog(7, "$x: perm could not modify.\n");
			}
		} elsif ($path && ! -l $path) {
			unless (chmod($val, $path)) {
				warn("chmod($path): $!");
				return undef;
			}
			$a->{$key} = $val;
			$modify++;
			plog(8, "$x: perm modify ok.\n");
		} else {
			plog(7, "$x: mtime no file found, ignored.\n");
			### return undef;
		}
	} elsif ($op == 3) {
		$modify++;
		plog(8, "$x: perm will be changed.\n");
	} else {
		plog(7, "$x: perm check error.\n");
		return undef;
	}

	# Check owner / group
	$key = 'y_owner';
	$val = $b->{$key};
	if ($< || !exists($a->{$key}) || !defined($val)) {
		plog(8, "$x: skip owner test.\n");
	} elsif ($a->{$key} == $val && $a->{y_group} == $b->{y_group}) {
		plog(8, "$x: owner check ok.\n");
	} elsif ($op == 2) {
		if ($p->put_mode) { # this is FTP server's file
			plog(7, "$x: time0 do nothing, ignored.\n");
		} elsif ($path) {
			my $g = $b->{y_group};
			if (!defined($g) && !defined($g = (stat($path))[5])) {
				warn("stat($path): $!\n");
				return undef;
			}
			unless (chown($val, $g, $path)) {
				warn("chown($path): $!");
				return undef;
			}
			$a->{$key} = $val;
			$a->{y_group} = $g;
			$modify++;
			plog(8, "$x: owner modify ok.\n");
		} else {
			plog(7, "$x: owner no file found, ignored.\n");
			### return undef;
		}
	} elsif ($op == 3) {
		$modify++;
		plog(8, "$x: owner will be changed.\n");
	} else {
		plog(7, "$x: owner check error.\n");
		return undef;
	}

	# DEBUG only: At last, we validate once more.
	return undef unless $a->validate;

	# result is # of modifications.
	$modify;
}

# end of Fan::besame
1;
