# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 347 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/check.al)"
;# Check parameters
;# Most of parameters are checked by Fan::Param::setval.
sub check ($) {
	my $p = shift; # Must be a generated module.
	my $tmpkey;
	my $tmpdir;
	local $_;

	# DEBUG purpose only...
	ref($p) && $p->isa('Fan::Param')
		or confess("$p must be a Fan::Param object");

	# Check package name.
	my $y = $p->{param_name};
	if ($y !~ s/^RUN:://) {
		# what's happen?
		confess("$p: package name \"$y\" invalid");
	}

	# Default value for umask operation.
	if (oct($p->umask)) {
		umask(oct($p->umask));
	}

	# Default backup suffix is a tilda.
	if ($p->backup_suffix eq '') {
		$p->setval('backup_suffix', '~');
	}

	# Check username.
	if ($p->username eq '') {
		my $name = getpwuid($<);
		defined($name) || die("getpwuid returns undef, at");
		$p->setval('username', $name);
	}

	# Check hostname.
	if ($p->hostname eq '') {
		my $host;
		chomp($host = `hostname`);
		$host = 'nowhere' if $host eq '';
		$p->setval('hostname', $host);
	}

	# Check FTP username.
	if (!defined($p->ftp_user)) {
		$p->setval('ftp_user', 'anonymous');
	}

	# Check FTP password string.
	if (!defined($p->ftp_pass)) {
		$p->setval('ftp_pass', $p->username.'@'.$p->hostname);
	}

	# Check existence of required directories.
	for (qw|lock temp local remote master_db local_db remote_db|) {
		my $key = $_.'_directory';
		my $t = $p->subst_directory($p->getval($key));

		if ($t ne '') {
			$p->setval($key, $t);
		} else {
			$p->delete($key);
		}
	}

	# Default value for temporary directory.
	if (!defined($p->temp_directory)) {
		$p->setval('temp_directory', $ENV{'TMPDIR'} || "/tmp");
	}

	# Default lock directory is local_directory...
	if (!defined($p->lock_directory)) {
		$p->setval('lock_directory', $p->temp_directory);
	}

	# Check required directories.
	for (qw|local temp lock|) {
		my $key = $_.'_directory';
		my $t = $p->getval($key);
		unless (defined($t)) {
			warn("ERR($y): $_ directory \"$t\" not defined.\n");
			return undef;
		}
		unless (-d $t) {
			unless ($p->create_directory && mkdirhier($t, 0755)) {
				warn("ERR($y): mkdirhier(\"$t\") failed.\n");
				return undef;
			}
		}
	}

	# Check archive database directories...
	# remote_db_directory
	# local_db_directory

	# Check index directory.
	# master_db_directory

	# default value of *_dirinfo
	if ($p->use_dirinfo) {
		$p->setval('load_remote_dirinfo', 1)
			if !defined($p->load_remote_dirinfo);
		$p->setval('load_local_dirinfo', 1)
			if !defined($p->load_local_dirinfo);
		$p->setval('store_local_dirinfo', 1)
			if !defined($p->store_local_dirinfo);
	}

	# load dirinfo?
	if ($p->load_remote_dirinfo) {
		my $z = $p->transfer_file_regexp;
		$p->setval('transfer_file_regexp', "\n".'!/\/\.dirinfo/'.$z);
	}

	# load dirinfo?
	if ($p->store_local_dirinfo) {
		my $z = $p->override_file_regexp;
		$p->setval('override_file_regexp', "\n".'!/\/\.dirinfo/'.$z);
	}

	# We must ignore lock files.
	if ($p->local_directory eq $p->lock_directory) {
		my $z = $p->override_file_regexp;
		$p->setval('override_file_regexp', "\n".'!/\.\/\.LOCK$/'.$z);
	}

	# We must not unlink renamed file if unlink == 2
	if ($p->unlink == 2) {
		my $z = $p->override_file_regexp;
		$p->setval('override_file_regexp',
			"\n".'!/'.$p->backup_suffix.'$/'.$z);
		$z = $p->override_directory_regexp;
		$p->setval('override_directory_regexp',
			"\n".'!/'.$p->backup_suffix.'\/$/'.$z);
	}

	# `change_directory = 1' is required
	# if `follow_symlink_regexp' is defined.
	$p->setval('change_directory', 1) if defined($p->follow_symlink);

	# Obsolete message.
	if (defined($p->{'lslR_map'})) {
		warn("WARN($y): lslR_map was obsoleted, ignored\n");
		delete($p->{'lslR_map'}); # obsolete
	}

	# If we create a copy of remote lslR file, we must not override it.
	if ($p->lslR_copy =~ /^[^\/]/) { # relative path...
		my $copy = lookup($p->lslR_copy);
		my $z = $p->override_file_regexp;
		$p->setval('override_file_regexp',
			"\n".'!/\.\/'.quotemeta($copy).'$/'.$z);
	}

	# Generate match routine
	for $tmpkey (qw(override_directory override_file
		transfer_directory transfer_file follow_symlink)) {
		$_ = $p->getval($tmpkey.'_regexp') || '';
		s/^\n//;
		my $c = &gen_match(split(/\n/));
		defined($c)
			or warn("ERR($y): $_ could not be defined\n"),
			return undef;
		$p->setval($tmpkey, $c);
	}

	# Generate substitution routine
	if (defined($_ = $p->symlink_map) && $_ ne '') {
		s/^\n//; # ignore first newline.
		my $c = &gen_subst(split(/\n/));
		ref($c) eq 'CODE'
			or warn("ERR($y): symlink-map error.\n"),
			return undef;
		$p->setval('symlink_subst', $c);
	}

	# Calculate timezone offset.
	if (defined($_ = $p->remote_timezone)) {
		if (/^(\+|-)(\d\d?)(\d\d)$/) {
			my $off = $2 * 3600 + $3 * 60;
			$p->setval('offset', $1 eq '+' ? $off : (0 - $off));
		}
	}

	;# success
	$p;
}

# end of Fan::check
1;
