# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 614 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/do_lock.al)"
;#
sub do_lock {
	my $p = shift;
	my $package = $p->{param_name};
	my $d = $p->lock_directory;

	# Check lock directory again.
	unless (-d $d && -w $d) {
		warn("$d: directory not found.\n");
		return undef;
	}

	# Try to lock this package...
	$package =~ s/^RUN:://
		or confess("ERR $package is invalid package name");

	my $lock = $d.'/LOCK.'.encode($package);

	# Lock mechanizm is supported by Cool.pm.
	plock($lock, 30) # wait max 30 seconds.
		or warn("plock($lock): $!\n"), return undef;

	# Register $lock as a temporary file.
	$p->{tempfiles}->{$lock}++;

	# Success
	1;
}

# end of Fan::do_lock
1;
