# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1462 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/fill_size.al)"
;#
sub fill_size ($$) {
	my $p = shift; # myself
	my $y = shift; # Attrib

	# debug log...
	warn("fill_size: try ".$y->path."\n") if $LOG > 6;

	# check if $y->size is defined.
	if (defined($y->size)) {
		warn("fill_size: already has size.\n") if $LOG > 6;
		return 1;
	}

	# we need ftp to get size.
	my $ftp = $p->via_ftp;
	unless (ref($ftp)) {
		warn("fill_size: no ftp session found.\n") if $LOG > 6;
		return undef;
	}

	# size command requires image mode
	unless ($ftp->image) {
		warn("fill_size: can't goto image mode\n") if $LOG > 6;
		return undef;
	}

	# try to get size.
	my $s = $ftp->size($y->path);
	unless (defined($s) && $y->size($s)) {
		warn("fill_size: fail to get size\n") if $LOG > 6;
		return undef;
	}

	# size found, debug log...
	warn("fill_size: $s (".$y->path.").\n") if $LOG > 6;

	# result must be o.k.
	1;
}

# end of Fan::fill_size
1;
