# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 178 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/full_setup.al)"
;# Initialize routine.
;#
sub full_setup ($$) {
	my $this = shift; # may be class name.
	my $arg = shift; # must a reference for an array.

	# Cleanup loader first.
	undef $loader;

	# We must have loader.
	$loader = Fan::Loader->new(
		loader_keys => \%pkeys,
		loader_nest => \%pnest,
	);
	ref($loader) && $loader->isa('Fan::Loader')
		or croak("full_setup: can't create loader");

	# Initial default parameters.
	$loader->merge_hash(\%initval, 'INIT')
		or croak("full_setup: can't initialize values");

	# Parsing options.
	$loader->parse_option($arg, 'OPTION')
		or croak("full_setup: can't parse option");

	# Initial array
	my @array = qw(INIT OPTION);

	# Set logging level first.
	if (defined(my $mask = $loader->get_value('log_mask', @array))) {
		plog_mask($mask);
	}

	# Configuration files to load.
	if (defined(my $files = $loader->get_value('load_config', @array))) {

		# Default directory for configuration files.
		my $dir = $loader->get_value('sysconfdir', @array);

		# load configuration files
		for my $file (split(/\s+/, $files)) {
			next if $file eq '';
			$file = "$dir/$file"
				if ! -f $file && $file !~ /^\// && $dir ne '';
			warn("loading $file...\n") if $LOG > 5;
			$loader->parse_file($file, 'DEFAULT')
				or croak("full_setup: can't parse $file.\n");
		}
	}

	# Success to full setup.
	1;
}

# end of Fan::full_setup
1;
