# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 551 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/gen_match.al)"
;# make pattern match subroutine
sub gen_match ($) {
	my $func = undef;
	my $default = 1;
	my $s = "\$func = sub {\n\tlocal(\$_) = \@_;\n";
	for my $re (@_) {
		local $_ = $re;
		my $type = s/^!// ? 0 : 1;
		my $use_regexp = 0;

		if (m%^/(.*)/$%) { # use regexp
			$_ = $1; $use_regexp = 1;
		} elsif (m%^'(.*)'$%) { # just match
			$_ = $1;
		}
		if ($_ eq '') {
			$default = $type; last;
		}
		if ($use_regexp) {
			$s .= "\treturn $type if /$_/o;\n";
		} else {
			$s .= "\treturn $type if \$_ eq '$_';\n";
		}
	}
	$s .= "\t$default;\n}\n";

	# debug information
	print "match: $s" if $LOG > 7;

	# evaluate subroutine definition
	eval $s;
	confess $@ if $@;

	# success - returns CODE.
	$func;
}

# end of Fan::gen_match
1;
