# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1517 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/local_add.al)"
;#
sub local_add {
	my $p = shift; # Fan
	my $y = shift; # Attrib we should add
	my $t = $y->type;
	my $from = $y->path; # server side file
	my $to = $p->local_directory.'/'.$from;
	1 while $to =~ s|/\./|/|;

	if ($t eq 'D') {
		return 1 if $p->test_mode;
		unlink($to); # force to remove
		unless (mkdir($to, 0755)) {
			warn("mkdir($to): $!");
			return undef;
		}
		warn("mkdir($from, 0755): o.k.\n") if $LOG > 6;
	} elsif ($t eq 'U') {
		; # simply ignored
	} elsif ($t eq 'F') {
		return 1 if $p->test_mode;
		# fill mtime if we don't have it
		$p->fill_mtime($y);
		# try to get file.
		unless ($p->get($from, $to)){
			warn("get($from, $to) failed: ");
			return undef;
		}
		warn("net::get($from): o.k.\n") if $LOG > 6;
	} elsif ($t eq 'L') {
		return 1 if $p->test_mode;
		unlink($to); # force to remove
		unless (symlink($y->linkto, $to)) {
			warn("symlink: $!");
			return undef;
		}
		warn("symlink($from): o.k.\n") if $LOG > 6;
	} else {
		; # what?
	}

	# Check modified file.
	my $a = Fan::Attrib->new(attr_path => $to);
	unless (ref($a) && $a->isa('Fan::Attrib')) {
		warn("Fan::Attrib::new $!");
		return undef;
	}

	# copy path variable
	$a->path($from);

	# check attribute again
	unless (defined($p->besame($a, $y, 2))) {
		warn("Can't modify $from");
		return undef;
	}

	# success
	1;
}

# end of Fan::local_add
1;
