# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2136 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/mkdirinfo.al)"
;#
;# Generate .dirinfo files for the local directory.
;#
sub mkdirinfo ($) {
	my $p = shift;
	my $dir = $p->local_directory;

	# try generate DIR object.
	use Fan::DIR;
	my $info = Fan::DIR->new(dir_path => $dir);

	# check result.
	unless (ref($info)) {
		carp("DIR($dir) can't be initialized.\n");
		return undef;
	}

	# let's try.
	if ($info->update) { # this is a recursive call.
		warn("$dir: modified.\n") if $LOG > 5;
	} else {
		warn("$dir: not modified.\n") if $LOG > 5;
	}

	# success to update .dirinfo files.
	1;
}

# end of Fan::mkdirinfo
1;
