# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1621 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/remote_add.al)"
;#
sub remote_add {
	my $p = shift; # Fan
	my $y = shift; # Attrib
	my $t = $y->type;
	my $to = $y->path;
	my $from = $p->local_directory.'/'.$to;
	1 while $from =~ s|/\./|/|;

	my $ftp = $p->via_ftp;
	ref($ftp) or confess("FTP is required for remote operation");

	if ($t eq 'L') {
		plog(7, "! We can't put symlink for $to, try real data.\n");
		$t = 'F';
	}

	if ($t eq 'D') {
		return 1 if $p->test_mode;
		$ftp->unlink($to); # ignore result.
		unless ($ftp->mkdir($to)) {
			warn("net::mkdir($to): ".$ftp->error);
			return undef;
		}
		warn("FTP::mkdir($to): o.k.\n") if $LOG > 6;
	} elsif ($t eq 'U') {
		; # simply ignored
	} elsif ($t eq 'F') {
		return 1 if $p->test_mode;
		unless ($ftp->image) {
			warn("FTP::image failed ".$ftp->error);
			return undef;
		}
		unless ($ftp->put($from, $to)) {
			warn("FTP::put($to): ".$ftp->error);
			return undef;
		}
		warn("FTP::put($to): o.k.\n") if $LOG > 6;
	} else {
		; # what?
	}

	if (($t eq 'D' || $t eq 'F') && (my $val = $y->perm) > 0) {
# warn("try chmod $to\n");
		unless ($ftp->chmod($val, $to)) {
			warn("FTP::chmod($to): [".$ftp->error."]\n")
				if $LOG >= 6;
			# but ignore this error
		}
	}

	1;
}

# end of Fan::remote_add
1;
