# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1675 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/remote_del.al)"
;#
sub remote_del {
	my $p = shift; # Fan
	my $y = shift; # Attrib
	my $t = $y->type;
	my $old = $y->path;
	my $ftp = $p->via_ftp;

	ref($ftp) or confess("FTP is required for remote operation");

	if ($p->unlink == 0) {
		warn("unlink($old) skipped by unlink-mode\n") if $LOG > 5;
		return 0;
	} elsif ($p->unlink == 2) {
		my $xx = $old.$p->backup_suffix;
		return 1 if $p->test_mode;
		unless ($ftp->rename($old, $xx)) {
			warn("FTP::rename($old, $xx): $!");
			return undef;
		}
		warn("FTP::rename $old: o.k.\n") if $LOG > 6;
		return 1;
	}

	if ($t eq 'D') {
		; # rmdir when 'U' was found
	} elsif ($t eq 'U') {
		plog(7, "FTP::rmdir($old)\n");
		return 1 if $p->test_mode;
		unless ($ftp->rmdir($old)) {
			warn("FTP::rmdir($old): ".$ftp->error);
			return undef;
		}
		warn("FTP::rmdir($old): o.k.\n") if $LOG > 6;
	} else {
		plog(7, "FTP::unlink($old)\n");
		return 1 if $p->test_mode;
		unless ($ftp->unlink($old)) {
			warn("FTP::unlink($old): ".$ftp->error);
			return undef;
		}
		warn("FTP::unlink($old): o.k.\n") if $LOG > 6;
	}

	1;
}

# end of Fan::remote_del
1;
