# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 1082 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/run_full_mirror.al)"
;#
;#
sub run_full_mirror {
	my $p = shift; # Fan object...

	warn("full_mirror: started\n") if $LOG > 5;

	unless ($p->net_init) {
		warn("step_synch: can't initialize network");
		return undef;
	}

	my $server = $p->remote_scanner;
	unless (ref($server)) {
		# carp("Can't create Scan object for FTP");
		return undef;
	}

	# local side scanner
	my $client = $p->local_scanner;
	unless (ref($client)) {
		# carp("Can't create Scan object");
		return undef;
	}

	# temporary variables...
	my $farm = undef;

	# check transfer mode
	if ($p->put_mode) {
		($server, $client) = ($client, $server);
	} else {
		# check index directory
		my $d = $p->master_db_directory;

		if (-d $p->local_db_directory) {
			; # this is slave server.
		} elsif ($d eq '') {
			; # no master_db_directory defined
		} elsif (! -d $d) { # warn, but ignored...
			warn("full_mirror: $d is not a directory.\n")
				if $LOG > 4;
		} else {
			$farm = Fan::Farm->new($d);
			unless (ref($farm) && $farm->d_begin) {
				warn("full_mirror: can't initialize Farm\n")
					if $LOG > 5;
				undef $farm;
			}
		}
	}

	my $x;
	my $y;
	while (($x, $y) = $client->getcmp($server)) {

		# result should be in $z.
		my $z;
		my $flag;
		my $modify = undef;

		# One of $x or $y must be defined.
		if (!defined($x) && !defined($y)) {
			die("Both of \$x and \$y are undef");
		} elsif (!defined($x)) { # only in server.
			$z = $y;
			$flag++;
		} elsif (!defined($y)) { # only in client.
			$z = $x;
			$flag--;
		} else { # in both of client and server
			$z = $y;
			$flag = 0;
		}

		# type abbrev...
		my $t = $z->type;

		# Is this END-OF-DATA?
		if ($t eq '.') {
			$flag == 0 or die("UNEXPECTED END-OF-DATA");
			$p->setval('success_terminate', 1);
			last;
		}

		# Check if we must get mtime of the file.
		# This must be before besame in the next block.
		if ($t eq 'F' && $p->ftp_force_mtime) {
			$p->fill_mtime($x) if ref($x) && !defined($x->mtime);
			$p->fill_mtime($y) if ref($y) && !defined($y->mtime);
		}

		# $flag == 0 means, both of server and client have
		# a file named $z->path.
		# Check if we must get/put file or not.
		# Besame returns undef if we must transfer the target.
		if ($flag == 0) {
			# Is checksum required?
			if ($t eq 'F' && !$p->put_mode) {
				# If target has checksum, we should fill it.
				if (length($y->checksum) == 32) {
					$x->fill_checksum if -f $x->realpath;
				}
			}
			# Check if we can modify or we must transfer.
			my $op = $p->test_mode ? 3 : 2; 
			$op |= 8 unless $p->ignore_mtime;
			$modify = $p->besame($x, $y, $op);
			$flag++ if !defined($modify);
		}

		# DEBUG only - check override...
		# This block can be skipped, since override check
		# was already done in add_filter for Scan object.
		# Can we override this?
		if ($t eq 'D') {
			my $file = $z->path;

			unless (&{$p->override_directory}($file.'/')) {
die("overrite_directory violation: $file/\n");
			}
		} elsif ($t eq 'F' || $t eq 'L') {
			my $file = $z->path;

			unless(&{$p->override_file}($file)) {
die("overrite_file violation: $file/\n");
			}
		}

		# show logging
		my $show = &Fan::Attrib::attr_encode($z->path);

		# Now, we can override.
		# Do real action.
		if ($flag < 0) { # DELETE
			$z->flag('-');

			if ($t eq 'D') {
				; # simply ignored
			} elsif ($p->del($z)) {
				plog(5, "-$t $show: success\n");
			} else {
				plog(5, "-$t $show: failure\n");
			}
		} elsif ($flag > 0) { # ADD
			$z->flag('+');

			if ($t eq 'U') {
				; # simply ignored
			} elsif ($p->add($z)) {
				plog(5, "+$t $show: success\n");
			} else {
				plog(5, "+$t $show: failure\n");
				$flag = -1;
			}
		} else {
			$z->flag('');

			if ($t eq 'U') {
				; # do nothing...
			} elsif ($modify) {
				$z->flag('+');
				plog(5, "+$t $show: modified\n");
			} else {
				plog(6, "#$t $show: ok\n");
			}
		}

		# Package index mangement tools
		if (ref($farm)) {
			# fill attributes...
			if ($flag >= 0) {
				$z->fill($p->local_directory.'/'.$z->path)
					or confess("Can't fill Fan::Attrib("
						. $z->path . ")");
				if ($t eq 'F' && length($z->checksum) != 32) {
					$z->fill_checksum;
				}
			}
			$farm->d_add($z);
		}

		# Check critical error...
		die("Fatal error detected in ftp connection, at")
			if ref($p->via_ftp) &&
			   $p->via_ftp->error == &Fan::TCP::FATAL;
	}

	# terminate network connection before heavy processing...
	undef $x;
	undef $y;
	$p->quit;

	# try terminate updater
	if (ref($farm)) {
		warn("full_mirror: terminate updater...\n") if $LOG > 5;
		$farm->d_end;
		warn("full_mirror: normalize my farm...\n") if $LOG > 5;
		$farm->normalize;
		warn("full_mirror: generate local index...\n") if $LOG > 5;
		$farm->genindex;
	}

	# writing lastest step file.
	if ($p->{newest_index} > 0) {
		my $seq = $p->{newest_index};

		if ($seq > 0 && $p->last_seq($seq)) {
			warn("full_mirror: wrote last seq = $seq.\n")
				if $LOG > 5;
		} else {
			warn("full_mirror: can't write last seq.\n")
				if $LOG > 5;
		}
	}

	# cleanup.
	$p->cleanup;

	# debug log...
	warn("full_mirror: done.\n") if $LOG > 5;

	#
	1;
}

# end of Fan::run_full_mirror
1;
