# NOTE: Derived from blib/lib/Fan.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Fan;

#line 2356 "blib/lib/Fan.pm (autosplit into blib/lib/auto/Fan/server_filter.al)"
;#
sub server_filter {
	my $y = shift; # Fan::Attrib object.
	my $p = shift; # Argument == Fan object.
	my $t = $y->type;
	my $x = $y->path;

	if ($t eq 'D' || $t eq 'U') {
		unless (&{$p->transfer_directory}($x.'/')) {
plog(7, "$x/... server file ignored (transfer)\n");
			return 0;
		}
		unless (&{$p->override_directory}($x.'/')) {
plog(7, "$x/... server file ignored (override)\n");
			return 0;
		}
	} elsif ($t eq 'F' || $t eq 'L') {
		unless (&{$p->transfer_file}($x)) {
plog(7, "$x... server file ignored (transfer)\n");
			return 0;
		}
		unless (&{$p->override_file}($x)) {
plog(7, "$x... server file ignored (override)\n");
			return 0;
		}
	}
plog(8, "$t $x... server file found\n") if defined($x);
	1;
}

# end of Fan::server_filter
1;
