package Net::Paraget::ClientManager;
#
# $Id: ClientManager.pm,v 1.2 2001/05/10 03:46:08 lrclause Exp $
#

use strict;

use Net::Paraget::Client;

use Class::MethodMaker
  get_set       => [ qw( tmp_dir child_program authoritative_size) ],
  list          => [ qw( clients ) ],
  new_with_init => 'new',
  new_hash_init => 'hash_init';


sub init
{
    my ( $self, %args ) = @_;
    my $tmp_dir = defined $ENV{TMPDIR} ? $ENV{TMPDIR} : '/tmp';
    
    $self->hash_init( tmp_dir       => $tmp_dir,
		      child_program => 'paraget-child',
		    );
    $self->hash_init( %args );
}


sub assign_clients
{
    my ( $self, @assignments ) = @_;
    
    foreach my $a ( @assignments )
    {
	my $client = Net::Paraget::Client->new( assignment => $a,
					     manager    => $self,
					   );
	$a->client( $client );
	$self->push_clients( $client );
	$client->start();
    }
}


1;
