package Net::Paraget::IntervalList;
#
# $Id: IntervalList.pm,v 1.1.1.1 2001/01/31 19:40:39 ftobin Exp $
#

use strict;

use Net::Paraget::Interval;

use Class::MethodMaker
  get_set       => [ qw( head ) ],
  new_hash_init => 'hash_init',
  new_with_init => 'new';


sub init
{
    my ( $self, %args ) = @_;
    $self->head( Net::Paraget::Interval->new() );
    $self->hash_init( %args );
}


sub first
{
    my ( $self ) = @_;
    return $self->head->next();
}


sub info
{
    my ( $self ) = @_;
    
    my @info;
    
    foreach my $interval ( $self->as_list() )
    {
	push @info, "interval: ", $interval->info(), "\n";
    }
    
    return @info;
}


sub initialize
{
    my ( $self, $interval ) = @_;
    my $head = $self->head();
    $head->next( $interval );
    $interval->prev( $head );

}


sub count
{
    my ( $self ) = @_;
    
    my $count = 0;
    
    for ( my $node = $self->first(); $node; $node = $node->next() )
    {
	$count++;
    }
    
    return $count;
}


sub as_list
{
    my ( $self ) = @_;
    
    my @nodes;
    
    for ( my $n = $self->first(); $n; $n = $n->next() )
    {
	push @nodes, $n;
    }
    
    return @nodes;
}


sub last
{
    my ( $self ) = @_;
    
    my $current = $self->first();
    
    while ( my $next = $current->next() )
    {
	$current = $next;
    }
    
    return $current;
}


1;
