package Net::Paraget::IntervalManager;
#
# $Id: IntervalManager.pm,v 1.2 2001/04/10 04:34:20 lrclause Exp $
#

use strict;

use Class::MethodMaker
  get_set       => [ qw( interval_list ) ],
  new_hash_init => [ qw( new hash_init ) ];

sub uncompleted
{
    my ( $self ) = @_;

    my @uncompleted = ();

    foreach my $interval ( $self->interval_list()->as_list() ) 
    {
	next if $interval->assignment;

	push @uncompleted, $interval;
    }

    return @uncompleted;
}


sub total_uncompleted_size
{
    my ($self) = @_;

    my $size = 0;

    foreach my $interval ( $self->uncompleted() ) 
    {
	$size += $interval->size;
    }

    return $size;
}



sub count_assigned
{
    my ( $self ) = @_;
    my $count = 0;
    foreach my $i ( $self->uncompleted() )
    {
	$count++ if $i->assignment();
    }
    return $count;
}


sub cleanup_uncompleted
{
    my ( $self, $report ) = @_;
    
    my $i = $self->interval_list->first();
    
    # Merge any two intervals that can easily be merged
    # Must be consecutive, flexible intervals

    while ( $i )
    {
	if ( $i->flexible() and $i->size() == 0 )
	{
	    my $next = $i->next();
	    $i->remove();
	    $i = $next;
	    next;
	}
	
	last unless $i->next();
	
	# first check the next for flexible, since we can skip
	# it if it's not flexible
	# If either interval is inflexible, we can't merge.
	# Optimization:  If the second is inflexible, skip that.
	if ( not $i->flexible() or
	     not $i->next()->flexible() )
	{
	    #$i = $next->next();  # skip the next too
	    $i = $i->next();
	    next;
	}
	
	# At this point, we're both flexible
	$i->merge_ahead();
    }
}


sub dump {
    my ( $self ) = @_;

    foreach ( $self->interval_list()->as_list() ) {
	print STDERR $_->info()."\n";
    }    
}

1;
