package Net::Paraget::Mirror;
#
# $Id: Mirror.pm,v 1.3 2001/05/04 03:14:57 lrclause Exp $
#

use strict;
use Carp;

use URI;

use Net::Paraget::Server;

use Class::MethodMaker
  get_set       => [ qw( type url server ) ],
  boolean       => [ qw( disabled ) ],
  new_hash_init => 'hash_init',
  new_with_init => 'new';


sub init
{
    my ( $self, $url ) = @_;
    
    $self->url( URI->new( $url ) );
}


sub server_id
{
    my ( $self ) = @_;
    
    carp "cannot determine server because url is not set"
      unless $self->url();
    
    return Net::Paraget::Server->host_scheme_as_string
	( $self->url->host(), $self->url->scheme() );
}


sub as_string
{
    my ( $self ) = @_;
    $self->url();
}

1;
