package Net::Paraget::MirrorSet;
#
# $Id: MirrorSet.pm,v 1.1.1.1 2001/01/31 19:40:39 ftobin Exp $
#

use strict;
use Carp;

use Class::MethodMaker
  hash          => 'mirrors_hash',
  new_hash_init => 'new';

sub count_able_mirrors
{
    my ( $self ) = @_;
    my $count = 0;
    foreach my $m ( $self->mirrors_hash_values() )
    {
	$count++ if not $m->disabled();
    }
    return $count;
}


sub mirrors
{
    my ( $self, @args ) = @_;
    croak( "You can't pass args to ", __PACKAGE__, "::mirrors" ) if @args;
    return $self->mirrors_hash_values();
}


sub count_mirrors
{
    my ( $self ) = @_;
    return scalar $self->mirrors_hash_keys();
}


sub add
{
    my ( $self, @new ) = @_;
    foreach ( @new )
    {
	$self->mirrors_hash( $_->as_string(), $_ );
    }
}


1;
