package Net::Paraget::PerformanceReport;
#
# $Id: PerformanceReport.pm,v 1.1.1.1 2001/01/31 19:40:39 ftobin Exp $
#

use strict;

use Class::MethodMaker
  get_set       => [ qw( assignment
			 amount_completed
			 work_time
			 had_error   timestamp
		       ) ],
  new_hash_init => 'hash_init',
  new_with_init => 'new';

sub init
{
    my ( $self, %args ) = @_;
    $self->timestamp( time );
    $self->hash_init( %args );
}


sub as_string
{
    my ( $self ) = @_;
    
    my $mirror = $self->mirror->as_string();
    my $amount = $self->amount_completed();
    my $speed  = $self->speed();
    my $error = $self->erorr() ? "yes" : "no";
    
    return "mirror $mirror, speed $speed, amount $amount, error $error";
}


1;
