package profxp::command;

use profxp::config;
use profxp::screen;
use profxp::tcp;

use Time::HiRes;

BEGIN {
  use Exporter;
  use vars qw($VERSION @ISA @EXPORT);

  $VERSION     = 0.1;
  @ISA         = qw(Exporter);
  @EXPORT      = qw(
                      &idle
                      &getlist
                   );
};


sub cmd_sd {
  if (unlink "$_[0].site") {
    info("site '$_[0]' removed",1);
    return 1;
  }
  else {
    error("no such site '$_[0]'",1);
    return 0;
  };
};


sub cmd_on {
  if (!($address = resolve($_[0]))) {
    error("can't find address for name '$_[0]'",1);
    return 0;
  };
  if (!($address eq $_[0])) {
    info("resolved $_[0] -> $address",2);
  };
  
  my %site = ();
  $site{name} = $_[0];
  $site{addr} = $_[0];
  $site{ip} = $address;
  $site{port} = $_[1] || 21;
  $site{user} = $_[2] || 'anonymous';
  $site{pass} = $_[3] || 'aol@aol.com';
  
  my $socksmode = 0;
  if ($cfg{cmode} > 1) {
    $socksmode = $cfg{socks}{type};
    info("attempting connect to $site{ip}:$site{port} via proxy at $cfg{socks}{ip}:$cfg{socks}{port}",1);
  }
  else {
    info("attempting connect to $site{ip} port $site{port}",1);
  };

  # open tcp channel
  my $sock = tcp_open(
                      $site{ip},
                      $site{port},
                      $cfg{localif},
                      0,
                      $cfg{timeout}{connect},
                      $socksmode,
                      $cfg{socks}{ip},
                      $cfg{socks}{port},
                      $cfg{socks}{user},
                      $cfg{socks}{pass}
                     );
                     
  if (!$sock) {
    error("could not connect to $_[0]",1);
    return 0;
  }
  else {
    info("connected, logging in",1);
  };
  
  if ($site{last} = login($sock,$site{user},$site{pass})) {
      info("logged on to $site{name}, use 'ss <sitename>' to bookmark it",1);
      # link site structure
      $site{sock} = $sock;
      $conn{$active} = \%site;
      $c{$sock} = $c{$active};
      $lcount = 9999;
      return 1;
  }
  else {
    tcp_close($sock);
    return 0;
  };
};

sub cmd_op {
  
  my $siteref;
  if (!($siteref = site_load($_[0]))) {
    error("no such site '$_[0]'",1);
    return 0;
  };
  my %site = %{ $siteref };
  
  if (!($site{ip} = resolve($site{addr}))) {
    error("can't find address for name '$site{addr}'",1);
    return 0;
  };
  if (!($site{ip} eq $site{addr})) {
    info("resolved $site{addr} -> $site{ip}",2);
  };
  
  my $socksmode = 0;
  if ($cfg{cmode} > 1) {
    $socksmode = $cfg{socks}{type};
    info("attempting connect to $site{ip}:$site{port} via proxy at $cfg{socks}{ip}:$cfg{socks}{port}",1);
  }
  else {
    info("attempting connect to $site{ip} port $site{port}",1);
  };
  
  # open tcp channel
  my $sock = tcp_open(
                      $site{ip},
                      $site{port},
                      $cfg{localif},
                      0,
                      $cfg{timeout}{connect},
                      $socksmode,
                      $cfg{socks}{ip},
                      $cfg{socks}{port},
                      $cfg{socks}{user},
                      $cfg{socks}{pass}
                     );
                     
  if (!$sock) {
    error("could not connect to $site{name} [".$site{addr}."]",1);
    return 0;
  }
  else {
    info("connected, logging in",1);
  };
  
  if ($site{last} = login($sock,$site{user},$site{pass},$site{last})) {
      info("logged on to '$site{name}'",1);
      # link site structure
      $site{sock} = $sock;
      $conn{$active} = \%site;
      $c{$sock} = $c{$active};
      $lcount = 9999;
      return 1;
  }
  else {
    tcp_close($sock);
    return 0;
  };
  
};

sub cmd_sl {
  opendir(CFGDIR,".");
  @sitefiles = grep /\.site$/, readdir CFGDIR;
  closedir(CFGDIR);
  info("-/-------------------------------------------------------------/-",1);
  info(" $c{boldwhite}profxp site listing$c{reset}                                          ",1);
  my %allsites = ();
  foreach (@sitefiles) {
    $_ =~ s/\.site$//;
    my $siteref = site_load($_);
    my %sitehash = %{ $siteref };
    if (defined($sitehash{slot})) {
      $allsites{$sitehash{slot}}{$sitehash{name}}  = sprintf("%16s",substr($sitehash{name},0,16));
      $allsites{$sitehash{slot}}{$sitehash{name}} .= " ".sprintf("%25s",substr($sitehash{addr},0,30));
      $allsites{$sitehash{slot}}{$sitehash{name}} .= " ".sprintf("%5s",substr($sitehash{port},0,5));
    }
    else {
      $allsites{'no-slot'}{$sitehash{name}}  = sprintf("%16s",substr($sitehash{name},0,16));
      $allsites{'no-slot'}{$sitehash{name}} .= " ".sprintf("%25s",substr($sitehash{addr},0,30));
      $allsites{'no-slot'}{$sitehash{name}} .= " ".sprintf("%5s",substr($sitehash{port},0,5));
    };
  };
  foreach my $slot (sort {lc($a) cmp lc($b)} keys(%allsites)) {
    my $pslot = sprintf("%30s",$c{yellow}.substr($slot,0,10).$c{reset});
    $pslot =~ s/ /\-/g;
    info(" ----------------------------------------".$pslot."----- ",1);
    foreach my $site (sort {lc($a) cmp lc($b)} keys(%{ $allsites{$slot} })) {
      info("$allsites{$slot}{$site}",1);
    };
  };
  info("-/-------------------------------------------------------------/-",1);
};

sub cmd_ss {
  
  my $name = $_[0];
  my $slot = $_[1];
  
  if ($name =~ /[^A-Za-z0-9_-]/) {
    error("sorry, site names may only contain characters [A-Za-z0-9_-]",1);
    return 0;
  };

  if ($slot =~ /[^A-Za-z0-9_-]/) {
    error("sorry, slot names may only contain characters [A-Za-z0-9_-]",1);
    return 0;
  };
  $conn{$active}{name} = $name;
  if ($slot) {
    $conn{$active}{slot} = $slot;
  };
  if (!site_save($conn{$active},$name)) {
    error("error while writing site file",1);
    return 0;
  };
  info("saved site '$name'",1);
  $lcount = 9999;
  return 1;
};

sub cmd_cf {
  if (!($_[0])) {
    # print list of options
    info("-/-------------------------------------------------------------/-",1);
    info(" $c{boldwhite}profxp configuration options$c{reset}                                    ",1);
    info(" --------------------------------------------------------------- ",1);
    my @options = sort {$a cmp $b} keys(%cfg);
    foreach (@options) {
      next if ($_ =~ /help/);
      next if ($_ =~ /^\./);
      if ($cfg{$_} =~ /ARRAY/) {
        info("  $c{yellow}$_$c{reset} [ $cfg{help}{$_} ]",1);
        foreach (@{ $cfg{$_} }) {
          next if ($_ =~ /^\./);
          info("     |- $c{yellow}'$_'$c{reset}",1);
        };
        next;
      };
      if ($cfg{$_} =~ /HASH/) {
        info("  $c{yellow}$_$c{reset} [ $cfg{help}{$_} ]",1);
        my $tmp = $_;
        foreach (keys( %{$cfg{$_}} )) {
          next if ($_ =~ /^\./);
          info("     |- $c{yellow}$_ = '$cfg{$tmp}{$_}' $c{reset}",1);
        };
        next;
      };
      info("  $c{yellow}$_ = '$cfg{$_}'$c{reset} [ $cfg{help}{$_} ]",1);
    };
    info(" --------------------------------------------------------------- ",1);
    info(" for simple toggles, '0' means OFF and '1' means ON              ",1);
    info("-/-------------------------------------------------------------/-",1);
  }
  else {
    if (exists($cfg{$_[0]})) {
      if ($cfg{$_[0]} =~ /HASH/) {
        if (exists($cfg{$_[0]}{$_[1]})) {
          if ($_[2] eq '') {
            delete $cfg{$_[0]}{$_[1]};
            info("deleted '$_[0] -> $_[1]' from list",1);
          }
          else {
            $cfg{$_[0]}{$_[1]} = $_[2];
            info("set '$_[0] -> $_[1]' to '$_[2]'",1);
          };
          cfg_save();
        }
        else {
          if ($cfg{$_[0]}{'.NON-FIXED'}) {
            $cfg{$_[0]}{$_[1]} = $_[2];
            cfg_save();
            info("added '$_[0] -> $_[1]' as '$_[2]'",1);
          }
          else {
            error("no such configuration flag, type 'cf' for a list",1);
          };
        };
      }
      elsif ($cfg{$_[0]} =~ /ARRAY/) {
        my $akey = $_[0];
        my $offset = 0;
        foreach (@{ $cfg{$_[0]} } ) {
          if ($_ eq $_[1]) {
            # delete the entry
            splice @{ $cfg{$_[0]} }, $offset, 1;
            cfg_save();
            info("removed entry '$_' from the '$_[0]' list",1);
            return 0;
          };
          $offset++;
        };
        push @{ $cfg{$_[0]} }, $_[1];
        cfg_save();
        info("added entry '$_[1]' to the '$_[0]' list",1);
      }
      else {
        $cfg{$_[0]} = $_[1];
        cfg_save();
        info("set '$_[0]' to '$_[1]'",1);
      };
    }
    else {
      error("no such configuration flag, type 'cf' for a list",1);
    };
  };
};


sub cmd_cl {
  logout($conn{$active}{sock});
  tcp_close($active);
  info("disconnected from '$conn{$active}{name}'",1);
  disconnect($active);
  $lcount = 9999;
  return 1;
};

sub cmd_cd {
  command($conn{$active}{sock},"CWD $_[0]","2..",2);
  $conn{$active}{last} = getcwd($conn{$active}{sock});
  $lcount = 9999;
};

sub cmd_ex {
  if (exists($conn{0}{sock})) {
    logout($conn{0}{sock});
  };
  if (exists($conn{1}{sock})) {
    logout($conn{1}{sock});
  };
  info("<PBallGod> I get fucked on every FLT pre",0);
  exit 0;
};


sub cmd_raw {
  command($conn{$active}{sock},"$_[0]",'...',1);
  return 1;  
};


sub cmd_he {
  if (!$_[0]) {
      info("-/-------------------------------------------------------------/-",1);
      info(" $c{boldwhite}profxp short reference$c{reset}                                          ",1);
      info(" -------------------------------------$c{yellow}site management commands$c{reset}-- ",1);
      info(" on <hostname/IP> [port] [user] [pass]        open new site with ",1);
      info("                                                current default  ",1);
      info("                                                conn. settings.  ",1);
      info(" op <sitename>                                open saved site    ",1);
      info("                                                (tab completion).",1);
      info(" cl                                           close active site. ",1);
      info(" ss <sitename> [slotname]                     save open site.    ",1);
      info(" sd <sitename>                                delete site.       ",1);
      info(" sl                                           site list.         ",1);
      info(" -------------------------------------$c{yellow}nav/list commands$c{reset}--------- ",1);
      info(" ls                                           list literally     ",1);
      info(" ld                                           list by date       ",1);
      info(" lr <flags>                                   raw listing with   ",1);
      info("                                                custom flags.    ",1);
      info(" cd <dir>                                     CWD to dir (doh!)  ",1);
      info(" -------------------------------------$c{yellow}fxp commands$c{reset}-------------- ",1);
      info(" xi <dir/file>                                recursive xfer     ",1);
      info("                                                 Wildcards: */?  ",1);
#      info(" qx                                           xfer queue.        ",1);
#      info(" qa                                           add to queue       ",1);
#      info("                                                 Wildcards: */?  ",1);
#      info(" qc                                           clear queue        ",1);
#      info(" qr                                           restore queue      ",1);
      info(" -------------------------------------$c{yellow}misc commands$c{reset}------------- ",1);
      info(" cf [flagname1] ... [flagvalue]               set config flag    ",1);
      info("                                               (no params->list) ",1);
      info(" vf <filename>                                view file          ",1);
      info(" rm <entry>                                   recursive delete   ",1);
      info("                                                 Wildcards: */?  ",1);
      info("                                                                 ",1);
      info(" *** Everything typed IN CAPS goes as-is to the server.          ",1);
      info(" *** ENTER toggles active/inactive connections.                  ",1);
      info(" *** Type 'he <command>' to get more help on specific commands   ",1);
      info("-/-------------------------------------------------------------/-",1);
  }
  else {
    if (exists($cmd{$_[0]})) {
      info("$_[0] - $cmd{$_[0]}{desc}",1);
      info("$cmd{$_[0]}{help}",1);
    }
    else {
      error("no such command '$_[0]'",1);
    };
  };
};

sub getcwd {
  my $path = command($_[0],"PWD","...",2);
  while (!($path =~ /^2.. .*\"(.*)\".*/)) {
    $path = command($_[0],undef,"...",2);
  };
  return('NO_PATH') if (!($path));
  return('PWD_ERROR') if ($path =~ /^5/);
  $path =~ s/.+\"(.*)\".*/$1/;
  return($path);
};

sub login {
  if ( (command($_[0],undef,"220",2)) && 
       (command($_[0],"USER $_[1]","331",2)) &&
       (command($_[0],"PASS $_[2]","230",2)) ) {
    # turn on unix-like directory listings
    # for windows servers
    if (command($_[0], "SYST","...",2) =~ /Windows/) {
       if (!(command($_[0], "SITE DIRSTYLE","...",2) =~ /off/i)) {
         command($_[0], "SITE DIRSTYLE","...",2);
       };
    };
    # CWD to initial path, if given
    if ($_[3]) {
      if (!command($_[0], "CWD $_[3]","25.",2)) {
        warning("Could not CWD to $_[3]",1);
      };
    };
    return(getcwd($_[0]));
  }
  else {
    error("user/pass not accepted or connection drop",1);
    return(0);
  };
};

sub logout {
  if ($_[0]) {
    command($_[0],"QUIT","...",2);
    tcp_close($_[0]);
  };
};

sub idle {
  alarm 0;
  if ( ($conn{$active}{sock}) || ($conn{$active^1}{sock}) ) {
    print "[Sending anti-idle, please wait]";
    if ($conn{($active)}{sock}) {
      command($conn{$active}{sock},$cfg{noopcmd},"...",0);
    };
    if ($conn{($active^1)}{sock}) {
      command($conn{$active^1}{sock},$cfg{noopcmd},"...",0);
    };
    print chr(8) x 32;
    print " " x 32;
    print chr(8) x 32;
  };
  $SIG{ALRM} = \&idle; 
  alarm $cfg{noopdelay};
};

sub cmd_ls {
  my $slist = getlist($conn{$active}{sock});
  return 0 if ($slist eq 0);
  my $pref = parselist($slist);
  printlist($pref,1);
};

sub cmd_ld {
  my $slist = getlist($conn{$active}{sock});
  return 0 if ($slist eq 0);
  my $pref = parselist($slist);
  printlist($pref,2);
};

sub cmd_lr {
  my $slist = getlist($conn{$active}{sock},$_[0]);
  return 0 if (!$slist);
  viewfile($slist);
};

sub cmd_vf {
  my $data = getlist($conn{$active}{sock},"RETR",$_[0]);
  if (!data) {
    error("file retrieval error",1);
    return 0;
  };
  viewfile($data);
};

sub viewfile {
  my $data = shift;
  open(TMP,"> /tmp/profxp.tmp.$$");
  print TMP $data;
  close(TMP);
  system("$cfg{viewer} /tmp/profxp.tmp.$$");
  unlink "/tmp/profxp.tmp.$$";
  $lcount = 9999;
};

sub getlist {
  my $listsocket = undef;
  my $sock = shift;
  my $listopts = shift || "-la";
  my $retr = shift;
  # LIST or RETR ?
  my $listcommand = "LIST $listopts";
  $listcommand = "RETR $retr" if ($retr);
  return 0 if (!(command($sock,"TYPE A","200",3)));
  # ACTIVE mode
  if ( ($cfg{cmode} == 1) ||
       ($cfg{cmode} == 3) ) {
    my $addr = undef;
    if (!($addr = resolve($cfg{localif}))) {
      error("invalid local address '$cfg{localif}'",1);
      return 0;
    };
    my $localsock = undef;
    if (!($localsock = tcp_listen($addr))) {
      error("listen on $addr failed (localif invalid ?)",1);
      return 0;
    };
    my $paddr = portstring($localsock);
    my $response = command($sock,"PORT $paddr","2..",2);
    if ($response) {
      if (!(command($sock,"$listcommand","1..",2))) {   
         error("listen OK, but LIST command failure.");
         return(0);
      };
      $listsocket = tcp_accept($localsock);
      if (!(defined($listsocket))) {
        error("cannot accept connection",1);
        abort($sock);
        abort_finish($sock);
        return(0);
      };
      tcp_close($localsock);
    }
    else {
      error("no connect arrived (local host firewalled ?)",1);
      return 0;
    };
  }
  # PASSIVE mode
  else {
    my $response = command($sock,"PASV","227",2);
    if ($response) {
      # calculate IP/port from response to PASV
      $response =~ s/^.*\((.+)\).*$/$1/;
      my @digits = split /\,/, $response;
      my $addr = $digits[0].".".$digits[1].".".$digits[2].".".$digits[3];
      my $port = ($digits[4]*256)+$digits[5];
      info("connecting to $addr:$port for listing",3);
      my $socksmode = 0;
      $socksmode = $cfg{socks}{type} if ($cfg{cmode} == 2);
      $listsocket = tcp_open(
                      $addr,
                      $port,
                      $cfg{localif},
                      0,
                      $cfg{timeout}{connect},
                      $socksmode,
                      $cfg{socks}{ip},
                      $cfg{socks}{port},
                      $cfg{socks}{user},
                      $cfg{socks}{pass}
                     );
      if (!(defined($listsocket))) {
         error("passive connection failed (firewalled ?)",1);
         return(0);
      };
      if (!(command($sock,"$listcommand","1..",2))) {
         error("passive connect ok, but LIST command failure",1);
         return(0);
      };
    }
    else {
      error("invalid response to PASV",1);
      return 0;
    };
  };
  my $slist = tcp_read($listsocket,0,$cfg{timeout}{data},1);
  tcp_close($listsocket);
  if (!(command($sock,undef,"2..",3))) {
    error("list data connection timeout, sending ABOR",1);
    abort($sock);
    abort_finish($sock);
    return(0);
  };
  
  # ret undef for empty dirs
  return undef if (!$slist);
  return($slist);
};

sub sregex {
  $regex = $_[0];
  # replace all non-word characters by /xXX
  # to prevent unwanted regexp crashes
  $regex =~ s/(\W)/sprintf("\\x%02X",ord($1))/eg;
  # replace \x2A ('*') by '.*'
  $regex =~ s/\\x2A/\.\*/g;
  # replace \x3F ('?') by '.'
  $regex =~ s/\\x3F/\./g;
  # add begin and end terminators
  $regex .= '$';
  $regex = '^'.$regex;
  return($regex);
};


sub rdeldir {
  return 0 if (!command($_[1],"CWD $_[0]","2..",1));
  info("$c{yellow}>>>$c{reset} Retrieving file listing $c{yellow}<<<$c{reset}",1);
	my %srclist = %{ parselist(getlist($_[1])) };
  foreach my $entry (sort byextension keys(%srclist)) {
    if ($srclist{$entry}{type} eq 'd') {
      rdeldir($entry,$_[1]);
    }
    else {
      command($_[1],"DELE $entry","...",1);
    };
  };
  command($_[1],"CDUP","...",1);
  command($_[1],"RMD $_[0]","...",1);
  return(1);
};

sub cmd_rm {
  del($_[0],$conn{$active}{sock});
};

sub del {
  my $result = 0;
  my $regex = sregex($_[0]);
  # get file/dir listing
  info("$c{yellow}>>>$c{reset} Retrieving file listing $c{yellow}<<<$c{reset}",1);
	my %srclist = %{ parselist(getlist($_[1])) };
	# collect the matches
	foreach my $match (sort byextension keys(%srclist)) {
	  if ($match =~ /$regex/) {
	    $result = 1;
	    if ($srclist{$match}{type} eq 'd') {
        rdeldir($match,$_[1]);
      }
      else {
        command($_[1],"DELE $match","2..",1);
      };
	  };
	};
	if (!$result) {
	  info("no such file or directory",1);
	};
	return($result);
};

sub cmd_qa {
  
  if ( ($conn{$active}{name} eq $conn{$active}{addr}) ||
       ($conn{$active^1}{name} eq $conn{$active^1}{addr}) ||
       ($conn{$active}{name} eq 'disconnected') ||
       ($conn{$active^1}{name} eq 'disconnected') ) {
    error("both sites must be connected and/or saved (bookmarked) to use the queue",1);
    return 0;
  };
  
  if (!add2queue($_[0],$conn{$active},$conn{$active^1})) {
    info("no matching files or directories found !",1);
  };
};


my $sortbyprefshashref;
sub byprefs {

  # everything reverse ?
  my $up = 1;
  my $down = -1;
  if ($cfg{sortrev} == 0) {
    $up = 1;
    $down = -1;
  }
  else {
    $up = -1;
    $down = 1;
  };
  
  # 1st see if the ext must b sorted up
  foreach (@{ $cfg{sortup}} ) {
    return $down if ($a =~ /$_$/i);
    return $up if ($b =~ /$_$/i);
  };
  
  my %sortbyprefshash = %{ $sortbyprefshashref };
  # both are dirs ?
  if ( ($sortbyprefshash{$a}{type} eq 'd') && ($sortbyprefshash{$b}{type} eq 'd') ) {
    return(lc($b) cmp lc($a)) if ($cfg{sortrev});
    return(lc($a) cmp lc($b));
  };
  
  # sort dirs up/down
  return $down if ($sortbyprefshash{$a}{type} eq 'd');
  return $up if ($sortbyprefshash{$b}{type} eq 'd');
  
  # the rest sorted (reverse) literal
  return (lc($b) cmp lc($a)) if ($cfg{sortrev});
  return (lc($a) cmp lc($b));
};


sub add2queue {

  my $regex = sregex($_[0]);
  my %source = %{ $_[1] };
  my %target = %{ $_[2] };

  # try to load queue file or create it
  my $qref;
  my %queue = ();
  if (!($qref = readini($source{name}.'->'.$target{name}.'-'.$$.'-queue'))) {
    info("creating queue '$source{name}' -> '$target{name}', pid $$",2);
    $queue{source} = \%source;
    $queue{target} = \%target;
    writeini(\%queue,$source{name}.'->'.$target{name}.'-'.$$.'-queue');
    $qref = readini($source{name}.'->'.$target{name}.'-'.$$.'-queue');
  };
  %queue = %{ $qref };
   
  my $oldverbose = $cfg{verbose};
  $cfg{verbose} = 1;
  
  my $src_cwd = getcwd($source{sock});
  my $dst_cwd = getcwd($target{sock});
  
	my %srclist = %{ parselist(getlist($source{sock})) };
	
	$sortbyprefshashref = \%srclist;
	my @sorted_src_list = sort byprefs keys(%srclist);
	
	my $result = 0;
	foreach my $match (@sorted_src_list) {
	  next if (($match =~ /^\./) && ($cfg{skipdot}));
	  if ($match =~ /$regex/) {
	    info(" |-- <DIR> $src_cwd",1) if (!$result);
	    $result = 1;
	    if ($srclist{$match}{type} eq 'd') {
        queue_add_dir($qref,$source{sock},$target{sock},$match,1);
      }
      else {
        $queue{$src_cwd}{$match} = $dst_cwd;
        info(" \\_ $match ($srclist{$match}{size} bytes)",1);
      };
    };
	};
	
  $cfg{verbose} = $oldverbose;
	
	writeini($qref,$source{name}.'->'.$target{name}.'-'.$$.'-queue');
	
	return($result);
};

sub queue_add_dir {
# 0 - qref 1 - src sock 2 - dst sock 3 - dirname
  my %queue = %{ $_[0] };
  
  my $response = command($_[1],"CWD $_[3]","2..",3);
  if (!($response)) {
		error("can't CWD to source dir '$_[3]'",1);
		return 0;
	};
	
	my $src_cwd = getcwd($_[1]);
	my $dst_cwd = getcwd($_[2]);

	my %srclist = %{ parselist(getlist($_[1])) };
  $sortbyprefshashref = \%srclist;
	my @sorted_src_list = sort byprefs keys(%srclist);
  
  my $result = 0;
	foreach my $match (@sorted_src_list) {
	  next if (($match =~ /^\./) && ($cfg{skipdot}));
	  info((' |' x $_[4])." |--<DIR> $src_cwd",1) if (!$result);
	  $result = 1;
	  if ($srclist{$match}{type} eq 'd') {
      queue_add_dir($_[0],$_[1],$_[2],$match,($_[4]+1));
    }
    else {
      $queue{$src_cwd}{$match} = $dst_cwd;
      info((' |' x $_[4])." \\_ $match ($srclist{$match}{size} bytes)",1);
    };
	};
  
  command($_[1],"CDUP","2..",3);
  
  return $result;
};

sub show_queue {
  

};


sub cmd_xi {
  fxp($_[0],$conn{$active}{sock},$conn{$active^1}{sock});
};

sub fxp {
  my $result = 0;
  my $regex = sregex($_[0]);

  info("$c{yellow}>>>$c{reset} Retrieving file listing $c{yellow}<<<$c{reset}",1);
	my %srclist = %{ parselist(getlist($_[1])) };
	foreach my $match (sort byextension keys(%srclist)) {
	  if ($match =~ /$regex/) {
	    $result = 1;
	    if ($srclist{$match}{type} eq 'd') {
        fxp_dir($match,$_[1],$_[2]);
      }
      else {
        if (! (($match =~ /^\./) && ($cfg{skipdot})) ) { 
          fxp_file($match,$_[1],$_[2],$srclist{$match}{size});
        };
      };
    };
	};
	if (!$result) {
	  info("no such file or directory",1);
	};
	return($result);
};

sub byextension {
  foreach (@{ $cfg{sortup}} ) {
    return -1 if ($a =~ /$_$/i);
    return 1 if ($b =~ /$_$/i);
  };
  return ($b cmp $a) if ($cfg{sortrev});
  return ($a cmp $b);
};

sub fxp_dir {
  my $response;
  info("$c{yellow}-=-$c{reset} recursive DIR transfer of '$_[0]' starting $c{yellow}-=-$c{reset}",1);
	$response = command($_[1],"CWD $_[0]","2..",2);
  if (!($response)) {
		error("can't CWD to source dir '$_[0]'",1);
		return 1;
	};
	info("$c{yellow}>>>$c{reset} Retrieving source file listing $c{yellow}<<<$c{reset}",1);
	my %srclist = %{ parselist(getlist($_[1])) };
	foreach (keys(%srclist)) {
	  if ( ($_ =~ /^\./) && ($cfg{skipdot}) ) {
	    delete $srclist{$_};
	    info("skipping dot file '$_'",2);
	  };
	};
	
	my $numfiles = keys(%srclist);
	if ( ($numfiles == 0) && ($cfg{skipempty}) ) {
	  info("directory is empty, skipping",2);
	  command($_[1],"CDUP","...",2);
	  return 0;
	};
	
	command($_[2],"MKD $_[0]","...",2);
	$response = command($_[2],"CWD $_[0]","2..",2);
  if (!($response)) {
		error("can't create or CWD to target dir $_[0]",1);
		command($_[1],"CDUP","...",2);
		return 1;
	};
  info("$c{yellow}>>>$c{reset} Retrieving destination file listing $c{yellow}<<<$c{reset}",1);
	
	my %dstlist = %{ parselist(getlist($_[2])) };
	
	my $exitcode = 0;
  my @sortedsrclist = sort byextension keys(%srclist);

	XFER: foreach my $entry (@sortedsrclist) {
		
		if ($srclist{$entry}{type} eq 'd') {
		  $response = fxp_dir($entry,$_[1],$_[2]);
			# break on fatal errors
			if ($response > 1) {
			  $exitcode = $response;
			  last XFER;
			};
			next;
		};

		if (  ($cfg{skipsame}) &&
		      ($srclist{$entry}{size} == $dstlist{$entry}{size})  ) {
		  info("skipping file '$entry', already present with same size.",1);
		}
		else {
      $response = fxp_file($entry,$_[1],$_[2],$srclist{$entry}{size});
			if ($response == 2) {
			  error("fatal error or user abort, stopping further transfers",1);
			  $exitcode = $response;
			  last XFER;
			};
		};
	};

	command($_[1],"CDUP","...",2);
	command($_[2],"CDUP","...",2);  
  return($exitcode);  
};

sub syncserver {
  info("attempting to resync server",1);
  my $path = command($_[0],"PWD","...",3);
  while (!($path =~ /^2.. .*\"(.*)\".*/)) {
    $path = command($_[0],undef,"...",3);
  };
};

# ----------------------------------------------------------- #
# fxp_file
# transfers a file
# <0> filename <1> Socket Source <2> Socket Target <3> Filesize
# Results: 0 - xfer ok  1 - error  2 - user abort or fatal error
sub fxp_file {
  info('',1);	
	info("$c{yellow}-=-$c{reset} XFER start for '$_[0]', size $_[3] bytes $c{yellow}-=-$c{reset}",1);
  if (!(command($_[1],"TYPE I","2..",3))) {
    error("setting binary type failed on SRC server",1);
    return(1);
  };
  if (!(command($_[2],"TYPE I","2..",3))) {
    error("setting binary type failed on DST server",1);
    return(1);
  };
  
	# -----------------------------------------------------------
	# run FXP
  
  my $fxpmode = $cfg{fmode} || 0;
  my $response = '';
  my $swapretry = 2;
  my $xferok = 1;
  my $userabort = 0;
  
  while ($swapretry) {
    
    $swapretry--;
    if (!$swapretry) {
      # toggle fxpmode and try again
      $fxpmode ^= 1;
      warning("now trying other FXP mode",1);
    };

    if ($fxpmode) {
      # alt
      $response = command($_[2],"PASV","227",2);
    }
    else {
      # normal
      $response = command($_[1],"PASV","227",2);
    };

	  if (!($response)) {
      warning("PASV command failure",1);
      syncserver($_[1]);
      syncserver($_[2]);
      next;
    };
  	
	  # get PASV IP/Port  
    $response =~ s/^.*\((.+)\).*$/$1/;
   
    # send it to the other server
    if ($fxpmode) {
      # alt
      $response = command($_[1],"PORT $response","200",2);
    }
    else {
      # normal
      $response = command($_[2],"PORT $response","200",2);
    };
    
	  if (!$response) {
      warning("PORT command failure",1);
      syncserver($_[1]);
      syncserver($_[2]);
      next;
    };
	  
	  # send first RETR or STOR
	  if ($fxpmode) {
      # alt
      $response = command($_[1],"RETR $_[0]","1..",2);
    }
    else {
      # normal
      $response = command($_[2],"STOR $_[0]","1..",2);
    };
	 
	  if (!($response)) {
      error("STOR/RETR failed (permission problem ?)",1);
      next;     
    };
    
    # send 2nd RETR or STOR
    if ($fxpmode) {
      # alt
      $response = command($_[2],"STOR $_[0]","1..",2);
    }
    else {
      # normal
      $response = command($_[1],"RETR $_[0]","1..",2);
    };
	 
	  if (!($response)) {
      error("STOR/RETR failed (timeout/firewall/permission problem ?)",1);
      if ($fxpmode) {
        abort($_[1]);
        abort_finish($_[1]);
        syncserver($_[1]);
        syncserver($_[2]);
      }
      else {
        abort($_[2]);
        abort_finish($_[2]);
        syncserver($_[1]);
        syncserver($_[2]);
      };
      next;
    };
    
    # fxp should be running now, start benchmark
    my $start = time();
		
    info("$c{yellow}>>>$c{reset} XFER running, hit 'a' to abort, 's' to stop after current file $c{yellow}<<<$c{reset}",1);
		
    # set non-blocking operation
    unblock($_[1]);
    unblock($_[2]);
		
    # wait-for-action-loop
    my $action = 0;
    my $keyclick = 0;
    while (!$action) {
      # check for data on SRC control connection
      if (tcp_peek($_[1])) {
        $action = 1;
      };
      # check for data on DST control connection
      if (tcp_peek($_[2])) {
        $action = 2;
      };
    
      # user abort
      if (!($userabort)) {
        $keyclick = getkey();
        if ($keyclick =~ /a/i) {
          abort($_[1],$_[2]);
          $userabort = 1;
        };
      };
    
      # be nice to the CPU
      select undef, undef, undef, 0.01;
    };
    
    # stop time
    my $xfertime = time() - $start;
    if ($xfertime == 0) {$xfertime = 0.1;};
    
    # set blocking operation
    block($_[1]);
    block($_[2]);
		
    # handle user abort 
    if ($userabort) {
      abort_finish($_[1],$_[2]);
      syncserver($_[1]);
      syncserver($_[2]);
      return(2);
    };
		
    # get response from server that showed action first
    if (!(command($_[$action],undef,"2..",1,120))) {
      error("transfer error, sending ABOR",1);
      abort($_[1],$_[2]);
      abort_finish($_[1],$_[2]);
      syncserver($_[1]);
      syncserver($_[2]);
      return(1);
    };

    # get response from other end
    if ($action == 1) {
      $response = command($_[2],undef,"2..",1,120);
    }
    else {
      $response = command($_[1],undef,"2..",1,120);
    };
    # send ABOR if failed
    if (!$response) {
      error("Transfer error, sending ABOR",1);
      abort($_[1],$_[2]);
      abort_finish($_[1],$_[2]);
      syncserver($_[1]);
      syncserver($_[2]);
      return(1);
    };
		
    # only show benchmark with files > 50kB
    if ($_[3] > 50000) {
      my $kbsec = sprintf("%.0ld kB/sec", $_[3]/1024/$xfertime);
      info("$c{yellow}-=-$c{reset} XFER of '$_[0]' complete ($c{red} $kbsec $c{reset}) $c{yellow}-=-$c{reset}",1);
    }
    else {
      info("$c{yellow}-=-$c{reset} XFER of '$_[0]' complete $c{yellow}-=-$c{reset}",1);
    };
			
    # if we swapped the FXP mode, make the change permanent for this session
    if (!$swapretry) {
      warning("detected successful FXP mode swap, keeping this mode for other transfers.",1);
      $cfg{fmode} = $fxpmode;
    };	
    
    $xferok = 0;
    last;
  };

  return($xferok);
};

1;
