package profxp::config;

BEGIN {
  use Exporter;
  use vars qw($VERSION @ISA @EXPORT);

  $VERSION     = 0.1;
  @ISA         = qw(Exporter);
  @EXPORT      = qw(
                      %c
                      %cfg
                      &cfg_load
                      &cfg_save
                      &site_load
                      &site_save
                      &disconnect
                      &writeini
                      &readini
                      %conn
                      $active
                   );
};

# color strings
%c = ();
$c{blue} = '%027%0910%0591%05934m';
$c{lila} = '%027%0910%05935m';
$c{magenta} = '%027%0910%0591%05935m';
$c{darkgreen} = '%027%0910%05932m';
$c{green} = '%027%0910%0591%05932m';
$c{cyan} = '%027%0910%05936m';
$c{white} = '%027%0910%05937m';
$c{boldwhite} = '%027%0910%0591%05937m';
$c{yellow} = '%027%0910%0591%05933m';
$c{red} = '%027%0910%0591%05931m';
$c{reset} = '%027%0910m';

foreach my $clr (keys(%c)) {
  $c{$clr} =~ s/\%([0-9][0-9][0-9])/chr($1)/ge;
};

$c{0} = $c{darkgreen};
$c{1} = $c{cyan};
$c{dircolor} = $c{yellow};
$c{linkcolor} = $c{blue};
$c{specialcolor} = $c{green};

# site hash w/ connected sites
$active = 0;
%conn = ();
%DISCONNECTED = (
                  'name' => 'disconnected',
                  'addr' => '0.0.0.0',
                  'port' => '0',
                  'user' => 'anonymous',
                  'pass' => 'aol@aol.com',
                  'path' => 'no-path',
                  'last' => 'no-path'
                );
$conn{0} = \%DISCONNECTED;
$conn{1} = \%DISCONNECTED;

sub disconnect {
  $conn{$_[0]} = \%DISCONNECTED;
};

# config w/ default settings
%cfg = ();
%default_cfg = (
           'aliases' => {
                        '.NON-FIXED' => 1,
                        'who' => 'Site who',
                        'new' => 'Site new',
                        'mkdir' => 'Mkd',
                        'rmdir' => 'Rmd',
                        'del' => 'Dele',
                        'chmod' => 'Site chmod'
                      },
           'localif' => '0.0.0.0',
           'timeout' => {
                          connect => 15,
                          command => 10,
                          data => 15
                        },
           'socks' => {
                        ip => '0.0.0.0',
                        port => 1080,
                        type => 4,
                        user => '',
                        pass => ''
                      },
           'listing' => {
                          color-age => 1,
                          showdot => 0,
                          pauselines => 30
                        },
           'cmode' => 0,
           'fmode' => 0,
           'xmode' => 0,
           'skipdot' => 1,
           'skipsame' => 1,
           'skipempty' => 1,
           'skipzero' => 0,
           'noopcmd' => 'NOOP',
           'noopdelay' => 60,
           'skipext' => [ 'diz', 'core' ],
           'viewer' => 'less',
           'verbose' => 2,
           'sortup' => [ 'nfo', 'sfv' ],
           'sortrev' => 0,
           'help' => {
                       'aliases' => 'aliases to abbreviate commands',
                       'sortup' => 'file extensions to transfer 1st in a listing',
                       'sortrev' => 'sort files literally reverse on multifile xfers',
                       'fmode' => 'FXP mode (0-normal 1-alt)',
                       'listing' => 'display options for directory listings',
                       'timeout' => 'various timeouts (in seconds)',
                       'localif' => 'the local interface to use for outgoing connections',
                       'socks' => 'set SOCKS parameters',
                       'cmode' => 'connection mode (0-direct_passive 1-direct_active 2-proxy_passive 3-proxy_active)',
                       'xmode' => 'FXP mode (0-standard 1-alternative)',
                       'skipsame' => 'skip files present with same size',
                       'skipdot' => 'skip dot files',
                       'skipempty' => 'skip empty directories',
                       'skipzero' => 'skip 0-byte files',
                       'skipext' => 'file extensions to skip',
                       'noopcmd' => 'anti-idle command to send (use NOOP or PWD)',
                       'noopdelay' => 'anti-idle interval in seconds',
                       'viewer' => 'text file viewer program',
                       'verbose' => 'set verbosity level (1 min, 3 max)'
                     }
       );

sub site_load {
  my $href;
  my $hash;
  if (!($href = readini("$_[0].site"))) {
    return 0;
  };
  %hash = %{ $href };
  return \%hash;
};


sub site_save {
  if (!(writeini($_[0],"$_[1].site"))) {
    return 0;
  };
  return 1;
};


sub cfg_load {
  my $href;
  if (!($href = readini('config'))) {
    if (!writeini(\%default_cfg,'config')) {
      return 0;
    };
    $href = readini('config');
    $main::firsttime = 1;
  };
  %cfg = %{ $href };
  return 1;
};

sub cfg_save {
  if (!writeini(\%cfg,'config')) {
    warning("could't write '~/.profxpv3/config'",1);
    return 0;
  };
  return 1;
};

sub writeini {
  my $href = shift;
  my %hash = %{ $href };
  my $fname = shift;
  if (!open(FINI,"> $fname")) {
    return 0;
  };
  my @hkeys = sort {$a cmp $b} keys(%hash);
  my @globals = ();
  foreach my $hkey (@hkeys) {
    next if ($hash{$hkey} =~ /GLOB/);
    if ($hash{$hkey} =~ /ARRAY/) {
      print FINI '['.&ini_encode($hkey).']'."\n";
      foreach (@{ $hash{$hkey} }) {
        print FINI &ini_encode($_)."\n";
      };
    }
    elsif ($hash{$hkey} =~ /HASH/) {
      print FINI '['.&ini_encode($hkey).']'."\n";
      foreach (keys %{ $hash{$hkey} }) {
        print FINI &ini_encode($_);
        print FINI " = ";
        print FINI &ini_encode($hash{$hkey}{$_})."\n";
      };
    }
    else {
      push @globals, $hkey;    
    };
  
    print FINI "\n";
  };
  print FINI '[global]'."\n";
  foreach my $hkey (@globals) {
    print FINI &ini_encode($hkey);
    print FINI " = ";
    print FINI &ini_encode($hash{$hkey})."\n";
  };
  close(FINI);
  return 1;
};

sub readini {
  my %hash = ();
  my $fname = shift;
  if (!open(FINI,"< $fname")) {
    return 0;
  };
  my $section = "UNDEF";
  LINE: while(<FINI>) {
    chop;
    s/^ +//;
    s/\#.*$//g;
    next if (!$_);
    next if ($_ =~ /^\#/);
    if ($_ =~ /^\[/) {
      s/\[(.+)\]//;
      $section = ini_decode($1);
      next;
    }
    elsif ($_ =~ /\=/) {
      my ($key,$value) = split / *\= */, $_;
      $key = ini_decode($key);
      $value = ini_decode($value);
      if ($section eq 'global') {
        $hash{$key} = $value;
      }
      else {
        $hash{$section}{$key} = $value;
      };
      next;
    }
    else {
      my $slice = ini_decode($_);
      if ($hash{$section} !~ /ARRAY/) {
        $hash{$section} = [ $slice ];
      }
      else {
        foreach (@{ $hash{$section} }) {
          next LINE if ($_ eq $slice);
        };
        push @{ $hash{$section} }, $slice;
      };
    };
  };
  return \%hash;
};

sub ini_encode {
  my $str = shift;
  $str =~ s/([^A-Za-z0-9.,:\/;_@() -])/sprintf("%%%02x",ord($1))/eg;
  return($str);
};

sub ini_decode {
  my $str = shift;
  $str =~ s/\%(..)/chr($1)/eg;
  return($str);
};

1;
