/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Vec3;
import java.util.Random;

public class Cells {
    double[] dx;
    double[] dy;
    double[] dz;
    Vec3 feature;
    Vec3 diff;
    Random random = new Random();
    int metric = 0;
    static double[] prob;
    public static final int EUCLIDEAN = 0;
    public static final int CITY_BLOCK = 1;
    public static final int CHESS_BOARD = 2;
    static final double DENSITY = 3.0;
    static final int[][] cellIndex;

    public Cells() {
        this.dx = new double[3];
        this.dy = new double[3];
        this.dz = new double[3];
        this.feature = new Vec3();
        this.diff = new Vec3();
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public void calcFunctions(Vec3 p, double[] value, Vec3[] grad, int[] id) {
        double dist2;
        int a = (int)Math.floor(p.x);
        int b = (int)Math.floor(p.y);
        int c = (int)Math.floor(p.z);
        double x = p.x - (double)a;
        double y = p.y - (double)b;
        double z = p.z - (double)c;
        int i = 0;
        while (i < value.length) {
            value[i] = Double.MAX_VALUE;
            ++i;
        }
        int seed = Cells.randSeed(a, b, c);
        this.random.setSeed(seed);
        this.random.nextInt();
        double rand = this.random.nextDouble();
        int num = 1;
        while (num < 9 && rand > prob[num]) {
            ++num;
        }
        i = 0;
        while (i < num) {
            this.feature.x = this.random.nextDouble();
            this.feature.y = this.random.nextDouble();
            this.feature.z = this.random.nextDouble();
            this.diff.x = x - this.feature.x;
            this.diff.y = y - this.feature.y;
            this.diff.z = z - this.feature.z;
            dist2 = this.distance(this.diff);
            this.sortIntoList(dist2, seed + i, value, grad, id);
            ++i;
        }
        this.dx[0] = x * x;
        this.dy[0] = y * y;
        this.dz[0] = z * z;
        this.dx[2] = (1.0 - x) * (1.0 - x);
        this.dy[2] = (1.0 - y) * (1.0 - y);
        this.dz[2] = (1.0 - z) * (1.0 - z);
        double r = value[value.length - 1];
        int cell = 0;
        while (cell < cellIndex.length) {
            i = cellIndex[cell][0];
            int j = cellIndex[cell][1];
            int k = cellIndex[cell][2];
            if (!(r < this.dx[i] + this.dy[j] + this.dz[k])) {
                seed = Cells.randSeed(a + --i, b + --j, c + --k);
                this.random.setSeed(seed);
                this.random.nextInt();
                rand = this.random.nextDouble();
                num = 1;
                while (num < 9 && rand > prob[num]) {
                    ++num;
                }
                int m = 0;
                while (m < num) {
                    this.feature.x = this.random.nextDouble() + (double)i;
                    this.feature.y = this.random.nextDouble() + (double)j;
                    this.feature.z = this.random.nextDouble() + (double)k;
                    this.diff.x = x - this.feature.x;
                    this.diff.y = y - this.feature.y;
                    this.diff.z = z - this.feature.z;
                    dist2 = this.distance(this.diff);
                    if (dist2 < value[value.length - 1]) {
                        this.sortIntoList(dist2, seed + m, value, grad, id);
                    }
                    ++m;
                }
                r = value[value.length - 1];
            }
            ++cell;
        }
        if (this.metric == 0) {
            i = 0;
            while (i < value.length) {
                value[i] = Math.sqrt(value[i]);
                if (grad != null) {
                    grad[i].scale(1.0 / value[i]);
                }
                ++i;
            }
        }
    }

    private static final int randSeed(int i, int j, int k) {
        return i * 10 + j * 1000 + k * 100000;
    }

    private final void sortIntoList(double dist2, int newid, double[] value, Vec3[] grad, int[] id) {
        int i = 0;
        while (i < value.length) {
            if (dist2 < value[i]) {
                int j = value.length - 1;
                while (j > i) {
                    value[j] = value[j - 1];
                    id[j] = id[j - 1];
                    if (grad != null) {
                        grad[j].set(grad[j - 1]);
                    }
                    --j;
                }
                value[i] = dist2;
                id[i] = newid;
                if (grad != null) {
                    if (this.metric == 0) {
                        grad[i].set(this.diff);
                    } else if (this.metric == 1) {
                        grad[i].set(this.diff.x > 0.0 ? 1.0 : -1.0, this.diff.y > 0.0 ? 1.0 : -1.0, this.diff.z > 0.0 ? 1.0 : -1.0);
                    } else {
                        double ax = Math.abs(this.diff.x);
                        double ay = Math.abs(this.diff.y);
                        double az = Math.abs(this.diff.z);
                        if (ax > ay) {
                            if (ax > az) {
                                grad[i].set(this.diff.x > 0.0 ? 1.0 : -1.0, 0.0, 0.0);
                            } else {
                                grad[i].set(0.0, 0.0, this.diff.z > 0.0 ? 1.0 : -1.0);
                            }
                        } else if (ay > az) {
                            grad[i].set(0.0, this.diff.y > 0.0 ? 1.0 : -1.0, 0.0);
                        } else {
                            grad[i].set(0.0, 0.0, this.diff.z > 0.0 ? 1.0 : -1.0);
                        }
                    }
                }
                return;
            }
            ++i;
        }
    }

    private final double distance(Vec3 diff) {
        if (this.metric == 0) {
            return diff.length2();
        }
        double ax = Math.abs(diff.x);
        double ay = Math.abs(diff.y);
        double az = Math.abs(diff.z);
        if (this.metric == 1) {
            return ax + ay + az;
        }
        if (ax > ay) {
            return ax > az ? ax : az;
        }
        return ay > az ? ay : az;
    }

    static {
        cellIndex = new int[][]{{0, 1, 1}, {2, 1, 1}, {1, 0, 1}, {1, 2, 1}, {1, 1, 0}, {1, 1, 2}, {0, 0, 1}, {0, 2, 1}, {0, 1, 0}, {0, 1, 2}, {2, 0, 1}, {2, 2, 1}, {2, 1, 0}, {2, 1, 2}, {1, 0, 0}, {1, 0, 2}, {1, 2, 0}, {1, 2, 2}, {0, 0, 0}, {0, 0, 2}, {0, 2, 0}, {0, 2, 2}, {2, 0, 0}, {2, 0, 2}, {2, 2, 0}, {2, 2, 2}};
        prob = new double[10];
        int i = 0;
        while (i < 10) {
            Cells.prob[i] = Math.pow(3.0, i) * Math.exp(-3.0);
            int j = 2;
            while (j <= i) {
                int n = i;
                prob[n] = prob[n] / (double)j;
                ++j;
            }
            ++i;
        }
        int i2 = 1;
        while (i2 < 10) {
            int n = i2;
            prob[n] = prob[n] + prob[i2 - 1];
            ++i2;
        }
    }
}

