/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.RGBColor;
import artofillusion.ui.ValueSlider;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ColorChooser
extends Dialog
implements ActionListener,
AdjustmentListener,
KeyListener,
ItemListener {
    RGBColor oldColor;
    RGBColor newColor;
    ValueSlider slider1;
    ValueSlider slider2;
    ValueSlider slider3;
    Label label1;
    Label label2;
    Label label3;
    Panel oldColorPatch;
    Panel newColorPatch;
    Choice modeC;
    static int mode = 1;

    public ColorChooser(Frame parent, String title, RGBColor c) {
        super(parent, title, true);
        GridBagConstraints gc = new GridBagConstraints();
        this.oldColor = c;
        this.newColor = c.duplicate();
        Panel p = new Panel();
        Button b = new Button("Ok");
        p.add(b);
        b.setActionCommand("ok");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("cancel");
        b.addActionListener(this);
        this.add((Component)p, "South");
        p = new Panel();
        p.setLayout(new GridBagLayout());
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.gridx = 0;
        this.label1 = new Label("Red");
        p.add((Component)this.label1, gc);
        this.slider1 = new ValueSlider(0.0, 1.0, 100, this.newColor.getRed());
        p.add((Component)this.slider1, gc);
        this.slider1.addAdjustmentListener(this);
        this.label2 = new Label("Green");
        p.add((Component)this.label2, gc);
        this.slider2 = new ValueSlider(0.0, 1.0, 100, this.newColor.getGreen());
        p.add((Component)this.slider2, gc);
        this.slider2.addAdjustmentListener(this);
        this.label3 = new Label("Blue");
        p.add((Component)this.label3, gc);
        this.slider3 = new ValueSlider(0.0, 1.0, 100, this.newColor.getBlue());
        p.add((Component)this.slider3, gc);
        this.slider3.addAdjustmentListener(this);
        gc.gridwidth = 1;
        p.add((Component)new Label("Color Model:"), gc);
        gc.gridx = 1;
        this.modeC = new Choice();
        p.add((Component)this.modeC, gc);
        this.modeC.addItem("RGB");
        this.modeC.addItem("HSV");
        this.modeC.addItem("HLS");
        this.modeC.addItemListener(this);
        this.modeC.select(mode);
        this.modeChanged();
        gc.fill = 0;
        gc.gridx = 2;
        p.add((Component)new Label("Original Color"), gc);
        this.oldColorPatch = this.oldColor.getSample(50, 30);
        p.add((Component)this.oldColorPatch, gc);
        p.add((Component)new Label("New Color"), gc);
        this.newColorPatch = this.newColor.getSample(50, 30);
        p.add((Component)this.newColorPatch, gc);
        this.add((Component)p, "Center");
        this.addAsListener(this);
        this.pack();
        this.setResizable(false);
        ModellingApp.centerWindow(this);
        this.show();
    }

    private void addAsListener(Component c) {
        c.addKeyListener(this);
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            int i = 0;
            while (i < children.length) {
                this.addAsListener(children[i]);
                ++i;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            this.oldColor.setRGB(this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue());
            this.dispose();
        } else if (e.getActionCommand().equals("cancel")) {
            this.dispose();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        float newValue = (float)e.getValue() / 100.0f;
        float[] values = new float[]{(float)this.slider1.getValue(), (float)this.slider2.getValue(), (float)this.slider3.getValue()};
        if (mode == 0) {
            this.newColor.setRGB(values[0], values[1], values[2]);
        } else if (mode == 1) {
            this.newColor.setHSV(values[0] * 360.0f, values[1], values[2]);
        } else {
            this.newColor.setHLS(values[0] * 360.0f, values[1], values[2]);
        }
        this.newColorPatch.setBackground(this.newColor.getColor());
        this.newColorPatch.repaint();
    }

    public void itemStateChanged(ItemEvent e) {
        mode = this.modeC.getSelectedIndex();
        this.modeChanged();
    }

    public void keyPressed(KeyEvent ev) {
        int code = ev.getKeyCode();
        if (code != 10 && code != 27) {
            return;
        }
        if (code == 10 && ev.getSource() instanceof Button) {
            return;
        }
        if (code == 10) {
            this.oldColor.setRGB(this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue());
        }
        this.dispose();
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void keyTyped(KeyEvent ev) {
    }

    void modeChanged() {
        float[] values;
        if (mode == 0) {
            this.label1.setText("Red");
            this.label2.setText("Green");
            this.label3.setText("Blue");
            values = new float[]{this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue()};
        } else if (mode == 1) {
            this.label1.setText("Hue");
            this.label2.setText("Saturation");
            this.label3.setText("Value");
            values = this.newColor.getHSV();
            values[0] = (float)((double)values[0] / 360.0);
        } else {
            this.label1.setText("Hue");
            this.label2.setText("Lightness");
            this.label3.setText("Saturation");
            values = this.newColor.getHLS();
            values[0] = (float)((double)values[0] / 360.0);
        }
        this.slider1.setValue(values[0]);
        this.slider2.setValue(values[1]);
        this.slider3.setValue(values[2]);
    }
}

