/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.CoordinateSystem;
import artofillusion.EditingTool;
import artofillusion.EditingWindow;
import artofillusion.LayoutWindow;
import artofillusion.ObjectInfo;
import artofillusion.Scene;
import artofillusion.SceneCamera;
import artofillusion.UndoRecord;
import artofillusion.Vec3;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class CreateCameraTool
extends EditingTool {
    static Image icon;
    static Image selectedIcon;
    static int counter;
    Point clickPoint;

    public CreateCameraTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("camera.gif");
        selectedIcon = this.loadImage("selected/camera.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText("Click to create a camera.");
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Scene theScene = ((LayoutWindow)this.theFrame).getScene();
        Camera cam = view.getCamera();
        Vec3 orig = cam.convertScreenToWorld(e.getPoint(), 20.0);
        Vec3 ydir = new Vec3(0.0, 1.0, 0.0);
        Vec3 zdir = new Vec3(0.0, 0.0, 1.0);
        ObjectInfo info = new ObjectInfo(new SceneCamera(), new CoordinateSystem(orig, zdir, ydir), "Camera " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        ((LayoutWindow)this.theFrame).addObject(info, undo);
        this.theWindow.setUndoRecord(undo);
        Vector objects = theScene.getObjects();
        ((LayoutWindow)this.theFrame).setSelection(objects.size() - 1);
        this.theWindow.updateImage();
    }

    static {
        counter = 2;
    }
}

